/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBus;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;

public class HgRepositoryWatcher
extends AbstractProjectComponent
implements BulkFileListener,
VcsListener {
    private final Collection<LocalFileSystem.WatchRequest> myWatchRequests;
    private final Collection<VirtualFile> myRoots;
    private VcsDirtyScopeManager myDirtyScopeManager;
    private ProjectLevelVcsManager myVcsManager;
    private AbstractVcs myVcs;

    protected HgRepositoryWatcher(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/HgRepositoryWatcher", "<init>"));
        }
        super(project);
        this.myWatchRequests = new HashSet<LocalFileSystem.WatchRequest>();
        this.myRoots = new HashSet<VirtualFile>();
    }

    public void initComponent() {
        MessageBus messageBus = this.myProject.getMessageBus();
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        messageBus.connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myVcs = HgVcs.getInstance(this.myProject);
    }

    public void disposeComponent() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
        this.myWatchRequests.clear();
        this.myRoots.clear();
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/zmlx/hg4idea/HgRepositoryWatcher", "before"));
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/zmlx/hg4idea/HgRepositoryWatcher", "after"));
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            VirtualFile root = this.getRootForIndexFile(file);
            if (root != null) {
                this.myDirtyScopeManager.dirDirtyRecursively(root);
            }
            if ((root = this.getRootForChangeBranch(file)) == null) continue;
            ((HgUpdater)this.myProject.getMessageBus().syncPublisher(HgVcs.REMOTE_TOPIC)).update(this.myProject, root);
            ((HgUpdater)this.myProject.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.myProject, root);
        }
    }

    @Nullable
    private VirtualFile getRootForIndexFile(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        for (VirtualFile root : this.myRoots) {
            if (!HgRepositoryWatcher.isDirstateFile(file, root) && !HgRepositoryWatcher.isUndoDirstateFile(file, root)) continue;
            return root;
        }
        return null;
    }

    private static boolean isDirstateFile(VirtualFile file, VirtualFile root) {
        return FileUtil.pathsEqual((String)(root.getPath() + "/.hg/dirstate"), (String)file.getPath());
    }

    private static boolean isUndoDirstateFile(VirtualFile file, VirtualFile root) {
        return FileUtil.pathsEqual((String)(root.getPath() + "/.hg/undo.dirstate"), (String)file.getPath());
    }

    @Nullable
    private VirtualFile getRootForChangeBranch(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        for (VirtualFile root : this.myRoots) {
            if (!HgRepositoryWatcher.isChangeBranchFile(file, root) && !HgRepositoryWatcher.isUndoChangeBranchFile(file, root)) continue;
            return root;
        }
        return null;
    }

    private static boolean isChangeBranchFile(VirtualFile file, VirtualFile root) {
        return FileUtil.pathsEqual((String)(root.getPath() + "/.hg/branch"), (String)file.getPath());
    }

    private static boolean isUndoChangeBranchFile(VirtualFile file, VirtualFile root) {
        return FileUtil.pathsEqual((String)(root.getPath() + "/.hg/undo.branch"), (String)file.getPath());
    }

    private void registerRoot(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/HgRepositoryWatcher", "registerRoot"));
        }
        this.myWatchRequests.add(LocalFileSystem.getInstance().addRootToWatch(root.getPath(), true));
        this.myRoots.add(root);
    }

    public void directoryMappingChanged() {
        for (VirtualFile root : this.myVcsManager.getRootsUnderVcs(this.myVcs)) {
            this.registerRoot(root);
        }
    }
}

