/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDeleteStatement;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNWCDbDeleteNodesRecursive
extends SVNSqlJetDeleteStatement {
    private Collection<File> paths;
    private Set<String> excludedPresences;

    public SVNWCDbDeleteNodesRecursive(SVNSqlJetDb sDb) throws SVNException {
        super(sDb, SVNWCDbSchema.NODES);
    }

    @Override
    protected Object[] getWhere() throws SVNException {
        return new Object[]{this.getBind(1)};
    }

    @Override
    protected boolean isFilterPassed() throws SVNException {
        String presence;
        long collectDepth;
        long rowDepth = this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
        if (this.paths != null && rowDepth >= (collectDepth = ((Long)this.getBind(4)).longValue()) && !this.excludedPresences.contains(presence = this.getColumnString(SVNWCDbSchema.NODES__Fields.presence))) {
            this.paths.add(SVNFileUtil.createFilePath(this.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath)));
        }
        long selectDepth = (Long)this.getBind(3);
        return this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth) >= selectDepth;
    }

    @Override
    protected String getPathScope() {
        return (String)this.getBind(2);
    }

    public void setCollectPaths(Collection<File> paths) {
        this.paths = paths;
        if (this.excludedPresences == null) {
            this.excludedPresences = new HashSet<String>();
            this.excludedPresences.add("base-deleted");
            this.excludedPresences.add("not-present");
            this.excludedPresences.add("excluded");
            this.excludedPresences.add("absent");
        }
    }

    @Override
    public void reset() throws SVNException {
        this.paths = null;
        super.reset();
    }
}

