/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.tmatesoft.svn.core.SVNProperty;

public class SVNPropertyValue
implements Serializable {
    private static final long serialVersionUID = 4845L;
    private String myValue;
    private byte[] myData;

    public static SVNPropertyValue create(String propertyName, byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        if (SVNProperty.isSVNProperty(propertyName)) {
            String value;
            try {
                value = new String(data, offset, length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                value = new String(data, offset, length);
            }
            return new SVNPropertyValue(value);
        }
        return new SVNPropertyValue(data, offset, length);
    }

    public static SVNPropertyValue create(String propertyName, byte[] data) {
        if (data == null) {
            return null;
        }
        return SVNPropertyValue.create(propertyName, data, 0, data.length);
    }

    public static SVNPropertyValue create(String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        return new SVNPropertyValue(propertyValue);
    }

    public static byte[] getPropertyAsBytes(SVNPropertyValue value) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            try {
                return value.getString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return value.getString().getBytes();
            }
        }
        return value.getBytes();
    }

    public static String getPropertyAsString(SVNPropertyValue value) {
        if (value == null) {
            return null;
        }
        if (value.isBinary()) {
            try {
                return new String(value.getBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(value.getBytes());
            }
        }
        return value.getString();
    }

    public boolean isBinary() {
        return this.myData != null;
    }

    public byte[] getBytes() {
        return this.myData;
    }

    public boolean isString() {
        return this.myValue != null;
    }

    public String getString() {
        return this.myValue;
    }

    public String toString() {
        if (this.isBinary()) {
            return "property is binary";
        }
        return this.getString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SVNPropertyValue) {
            SVNPropertyValue value = (SVNPropertyValue)obj;
            if (this.isString()) {
                return this.myValue.equals(SVNPropertyValue.getPropertyAsString(value));
            }
            if (this.isBinary()) {
                return Arrays.equals(this.myData, SVNPropertyValue.getPropertyAsBytes(value));
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.myValue != null) {
            return this.myValue.hashCode();
        }
        if (this.myData != null) {
            return this.myData.hashCode();
        }
        return super.hashCode();
    }

    private SVNPropertyValue(byte[] data, int offset, int length) {
        this.myData = new byte[length];
        System.arraycopy(data, offset, this.myData, 0, length);
    }

    private SVNPropertyValue(String propertyValue) {
        this.myValue = propertyValue;
    }
}

