/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.psi;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveProcessor;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.psi.IpnbPyFragment;

public class IpnbPyReference
extends PyReferenceImpl {
    public IpnbPyReference(PyQualifiedExpression element, @NotNull PyResolveContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/ipnb/psi/IpnbPyReference", "<init>"));
        }
        super(element, context);
    }

    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
        return HighlightSeverity.WARNING;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList variants = Lists.newArrayList();
        Collections.addAll(variants, super.getVariants());
        PsiFile file = this.myElement.getContainingFile();
        if (file instanceof IpnbPyFragment) {
            IpnbFilePanel panel = ((IpnbPyFragment)file).getFilePanel();
            List<IpnbEditablePanel> panels = panel.getIpnbPanels();
            for (IpnbEditablePanel editablePanel : panels) {
                if (!(editablePanel instanceof IpnbCodePanel)) continue;
                Editor editor = ((IpnbCodePanel)editablePanel).getEditor();
                IpnbPyFragment psiFile = (IpnbPyFragment)PsiDocumentManager.getInstance((Project)this.myElement.getProject()).getPsiFile(editor.getDocument());
                if (psiFile == null) continue;
                CompletionVariantsProcessor processor = new CompletionVariantsProcessor((PsiElement)this.myElement);
                PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor, (ScopeOwner)psiFile, null, null);
                for (LookupElement e : processor.getResultList()) {
                    PsiElement original;
                    Object o = e.getObject();
                    if (o instanceof PsiElement && (original = CompletionUtil.getOriginalElement((PsiElement)((PsiElement)o))) == null) continue;
                    variants.add(e);
                }
            }
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/psi/IpnbPyReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file;
        ResolveResult[] results = super.multiResolve(incompleteCode);
        if (results.length == 0 && (file = this.myElement.getContainingFile()) instanceof IpnbPyFragment) {
            IpnbFilePanel panel = ((IpnbPyFragment)file).getFilePanel();
            List<IpnbEditablePanel> panels = panel.getIpnbPanels();
            String referencedName = this.myElement.getReferencedName();
            if (referencedName == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/psi/IpnbPyReference", "multiResolve"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            for (IpnbEditablePanel editablePanel : panels) {
                if (!(editablePanel instanceof IpnbCodePanel)) continue;
                Editor editor = ((IpnbCodePanel)editablePanel).getEditor();
                IpnbPyFragment psiFile = (IpnbPyFragment)PsiDocumentManager.getInstance((Project)this.myElement.getProject()).getPsiFile(editor.getDocument());
                if (psiFile == null) continue;
                ResolveProcessor processor = new ResolveProcessor(referencedName);
                PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor, (ScopeOwner)psiFile, (String)referencedName, (PsiElement)psiFile);
                List resultList = this.getResultsFromProcessor(referencedName, processor, (PsiElement)psiFile, (PsiElement)psiFile);
                if (resultList.size() <= 0) continue;
                List ret = RatedResolveResult.sorted((List)resultList);
                ResolveResult[] resolveResultArray = (ResolveResult[])ret.toArray(new RatedResolveResult[ret.size()]);
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/psi/IpnbPyReference", "multiResolve"));
                }
                return resolveResultArray;
            }
        }
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/psi/IpnbPyReference", "multiResolve"));
        }
        return results;
    }
}

