/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.python.psi.impl.PyFileImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeSourcePanel;
import org.jetbrains.plugins.ipnb.psi.IpnbPyLanguageDialect;

public class IpnbPyFragment
extends PyFileImpl {
    private PsiElement myContext;
    private boolean myPhysical;
    private final IpnbFilePanel myFilePanel;
    private final IpnbCodeSourcePanel myCodeSourcePanel;
    private FileViewProvider myViewProvider;

    public IpnbPyFragment(Project project, CharSequence text, boolean isPhysical, IpnbCodeSourcePanel codeSourcePanel) {
        super(((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager().createFileViewProvider((VirtualFile)new LightVirtualFile("code.py", (Language)IpnbPyLanguageDialect.getInstance(), text), isPhysical));
        this.myPhysical = isPhysical;
        this.myCodeSourcePanel = codeSourcePanel;
        this.myFilePanel = codeSourcePanel.getIpnbCodePanel().getFileEditor().getIpnbFilePanel();
        ((SingleRootFileViewProvider)this.getViewProvider()).forceCachedPsi((PsiFile)this);
    }

    public IpnbCodeSourcePanel getCodeSourcePanel() {
        return this.myCodeSourcePanel;
    }

    protected IpnbPyFragment clone() {
        IpnbPyFragment clone = (IpnbPyFragment)this.cloneImpl((FileElement)this.calcTreeElement().clone());
        clone.myPhysical = false;
        clone.myOriginalFile = this;
        FileManager fileManager = ((PsiManagerEx)this.getManager()).getFileManager();
        SingleRootFileViewProvider cloneViewProvider = (SingleRootFileViewProvider)fileManager.createFileViewProvider((VirtualFile)new LightVirtualFile(this.getName(), this.getLanguage(), (CharSequence)this.getText()), false);
        cloneViewProvider.forceCachedPsi((PsiFile)clone);
        clone.myViewProvider = cloneViewProvider;
        return clone;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    @NotNull
    public FileViewProvider getViewProvider() {
        if (this.myViewProvider != null) {
            FileViewProvider fileViewProvider = this.myViewProvider;
            if (fileViewProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/psi/IpnbPyFragment", "getViewProvider"));
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = super.getViewProvider();
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/psi/IpnbPyFragment", "getViewProvider"));
        }
        return fileViewProvider;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.myContext == null || this.myContext.isValid();
    }

    public boolean isPhysical() {
        return this.myPhysical;
    }

    public void setContext(PsiElement context) {
        this.myContext = context;
    }

    public IpnbFilePanel getFilePanel() {
        return this.myFilePanel;
    }
}

