/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbErrorOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbHtmlOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbJpegOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbLatexOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbPngOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbStreamOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbSvgOutputCell;
import org.jetbrains.plugins.ipnb.protocol.IpnbConnectionListener;

public class IpnbConnection {
    private static final String API_URL = "/api";
    private static final String KERNELS_URL = "/api/kernels";
    private static final String HTTP_POST = "POST";
    private static final String authMessage = "{\"header\":{\"msg_id\":\"\", \"msg_type\":\"connect_request\"}, \"parent_header\":\"\", \"metadata\":{}}";
    public static final String HTTP_DELETE = "DELETE";
    @NotNull
    private final URI myURI;
    @NotNull
    private final String myKernelId;
    @NotNull
    private final String mySessionId;
    @NotNull
    private final IpnbConnectionListener myListener;
    @NotNull
    private final WebSocketClient myShellClient;
    @NotNull
    private final WebSocketClient myIOPubClient;
    @NotNull
    private final Thread myShellThread;
    @NotNull
    private final Thread myIOPubThread;
    private volatile boolean myIsShellOpen;
    private volatile boolean myIsIOPubOpen;
    private volatile boolean myIsOpened;

    public IpnbConnection(@NotNull URI uri, @NotNull IpnbConnectionListener listener) throws IOException, URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "<init>"));
        }
        this.myIsShellOpen = false;
        this.myIsIOPubOpen = false;
        this.myIsOpened = false;
        this.myURI = uri;
        this.myListener = listener;
        this.mySessionId = UUID.randomUUID().toString();
        this.myKernelId = this.startKernel();
        Draft17WithOrigin draft = new Draft17WithOrigin();
        this.myShellClient = new WebSocketClient(this.getShellURI(), (Draft)draft){

            public void onOpen(@NotNull ServerHandshake handshakeData) {
                if (handshakeData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handshakeData", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$1", "onOpen"));
                }
                this.send(IpnbConnection.authMessage);
                IpnbConnection.this.myIsShellOpen = true;
                IpnbConnection.this.notifyOpen();
            }

            public void onMessage(@NotNull String message) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$1", "onMessage"));
                }
            }

            public void onClose(int code, @NotNull String reason, boolean remote) {
                if (reason == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$1", "onClose"));
                }
            }

            public void onError(@NotNull Exception e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$1", "onError"));
                }
            }
        };
        this.myShellThread = new Thread((Runnable)this.myShellClient);
        this.myShellThread.start();
        this.myIOPubClient = new WebSocketClient(this.getIOPubURI(), (Draft)draft){
            private ArrayList<IpnbOutputCell> myOutput;
            private Integer myExecCount;
            {
                this.myOutput = new ArrayList();
                this.myExecCount = null;
            }

            public void onOpen(ServerHandshake handshakeData) {
                this.send(IpnbConnection.authMessage);
                IpnbConnection.this.myIsIOPubOpen = true;
                IpnbConnection.this.notifyOpen();
            }

            public void onMessage(String message) {
                PyStatusContent content;
                Gson gson = new Gson();
                Message msg = (Message)gson.fromJson(message, Message.class);
                Header header = msg.getHeader();
                Header parentHeader = (Header)gson.fromJson((JsonElement)msg.getParentHeader(), Header.class);
                String messageType = header.getMessageType();
                if ("pyout".equals(messageType) || "display_data".equals(messageType)) {
                    PyOutContent content2 = (PyOutContent)gson.fromJson((JsonElement)msg.getContent(), PyOutContent.class);
                    IpnbConnection.addCellOutput(content2, this.myOutput);
                } else if ("pyerr".equals(messageType) || "error".equals(messageType)) {
                    PyErrContent content3 = (PyErrContent)gson.fromJson((JsonElement)msg.getContent(), PyErrContent.class);
                    IpnbConnection.addCellOutput(content3, this.myOutput);
                } else if ("stream".equals(messageType)) {
                    PyStreamContent content4 = (PyStreamContent)gson.fromJson((JsonElement)msg.getContent(), PyStreamContent.class);
                    IpnbConnection.addCellOutput(content4, this.myOutput);
                } else if ("pyin".equals(messageType) || "execute_input".equals(messageType)) {
                    JsonElement executionCount = msg.getContent().get("execution_count");
                    if (executionCount != null) {
                        this.myExecCount = executionCount.getAsInt();
                    }
                } else if ("status".equals(messageType) && (content = (PyStatusContent)gson.fromJson((JsonElement)msg.getContent(), PyStatusContent.class)).getExecutionState().equals("idle")) {
                    IpnbConnection.this.myListener.onOutput(IpnbConnection.this, parentHeader.getMessageId(), (List)this.myOutput.clone(), this.myExecCount);
                    this.myOutput.clear();
                }
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        this.myIOPubThread = new Thread((Runnable)this.myIOPubClient);
        this.myIOPubThread.start();
    }

    private void notifyOpen() {
        if (!this.myIsOpened && this.myIsShellOpen && this.myIsIOPubOpen) {
            this.myIsOpened = true;
            this.myListener.onOpen(this);
        }
    }

    @NotNull
    public String execute(@NotNull String code) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "execute"));
        }
        String messageId = UUID.randomUUID().toString();
        this.myShellClient.send(new Gson().toJson((Object)this.createExecuteRequest(code, messageId)));
        String string = messageId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "execute"));
        }
        return string;
    }

    public void shutdown() {
        this.myIOPubClient.close();
        this.myShellClient.close();
    }

    public void close() throws IOException, InterruptedException {
        this.myIOPubThread.join();
        this.myShellThread.join();
        this.shutdownKernel();
    }

    @NotNull
    public String getKernelId() {
        String string = this.myKernelId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "getKernelId"));
        }
        return string;
    }

    @NotNull
    private String startKernel() throws IOException {
        String s = IpnbConnection.httpRequest(this.myURI + KERNELS_URL, HTTP_POST);
        Gson gson = new Gson();
        Kernel kernel = (Kernel)gson.fromJson(s, Kernel.class);
        String string = kernel.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "startKernel"));
        }
        return string;
    }

    private void shutdownKernel() throws IOException {
        IpnbConnection.httpRequest(this.myURI + KERNELS_URL + "/" + this.myKernelId, HTTP_DELETE);
    }

    @NotNull
    public URI getShellURI() throws URISyntaxException {
        URI uRI = new URI(this.getWebSocketURIBase() + "/shell");
        if (uRI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "getShellURI"));
        }
        return uRI;
    }

    @NotNull
    public URI getIOPubURI() throws URISyntaxException {
        URI uRI = new URI(this.getWebSocketURIBase() + "/iopub");
        if (uRI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "getIOPubURI"));
        }
        return uRI;
    }

    @NotNull
    private String getWebSocketURIBase() {
        String string = "ws://" + this.myURI.getAuthority() + KERNELS_URL + "/" + this.myKernelId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "getWebSocketURIBase"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static String httpRequest(@NotNull String url, @NotNull String method) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "httpRequest"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "httpRequest"));
        }
        URLConnection urlConnection = new URL(url).openConnection();
        if (urlConnection instanceof HttpURLConnection) {
            int n;
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            connection.setRequestMethod(method);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[4096];
            while ((n = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, n);
            }
            String string = builder.toString();
            String string2 = string;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "httpRequest"));
            }
            return string2;
            finally {
                reader.close();
            }
        }
        throw new UnsupportedOperationException("Only HTTP URLs are supported");
    }

    @NotNull
    public Message createExecuteRequest(String code, String messageId) {
        JsonObject content = new JsonObject();
        content.addProperty("code", code);
        content.addProperty("silent", Boolean.valueOf(false));
        content.add("user_variables", (JsonElement)new JsonArray());
        content.add("output_type", (JsonElement)new JsonPrimitive(""));
        content.add("user_expressions", (JsonElement)new JsonObject());
        content.addProperty("allow_stdin", Boolean.valueOf(false));
        Message message = this.createMessage("execute_request", content, messageId);
        if (message == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "createExecuteRequest"));
        }
        return message;
    }

    private Message createMessage(String messageType, JsonObject content, String messageId) {
        Header header = Header.create(messageId, "username", this.mySessionId, messageType);
        JsonObject parentHeader = new JsonObject();
        JsonObject metadata = new JsonObject();
        return Message.create(header, parentHeader, metadata, content);
    }

    private static void addCellOutput(@NotNull PyContent content, ArrayList<IpnbOutputCell> output) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection", "addCellOutput"));
        }
        if (content instanceof PyErrContent) {
            output.add(new IpnbErrorOutputCell(((PyErrContent)content).getEvalue(), ((PyErrContent)content).getEname(), ((PyErrContent)content).getTraceback(), null));
        } else if (content instanceof PyStreamContent) {
            String data = ((PyStreamContent)content).getData();
            output.add(new IpnbStreamOutputCell(((PyStreamContent)content).getName(), new String[]{data}, null));
        } else if (content instanceof PyOutContent) {
            Map<String, String> data = ((PyOutContent)content).getData();
            if (data.containsKey("text/latex")) {
                String text = data.get("text/latex");
                String plainText = data.get("text/plain");
                output.add(new IpnbLatexOutputCell(new String[]{text}, null, new String[]{plainText}));
            } else if (data.containsKey("text/html")) {
                String html = data.get("text/html");
                output.add(new IpnbHtmlOutputCell(StringUtil.splitByLinesKeepSeparators((String)html), StringUtil.splitByLinesKeepSeparators((String)html), null));
            } else if (data.containsKey("image/png")) {
                String png = data.get("image/png");
                String plainText = data.get("text/plain");
                output.add(new IpnbPngOutputCell(png, StringUtil.splitByLinesKeepSeparators((String)plainText), null));
            } else if (data.containsKey("image/jpeg")) {
                String jpeg = data.get("image/jpeg");
                String plainText = data.get("text/plain");
                output.add(new IpnbJpegOutputCell(jpeg, StringUtil.splitByLinesKeepSeparators((String)plainText), null));
            } else if (data.containsKey("image/svg")) {
                String svg = data.get("image/svg");
                String plainText = data.get("text/plain");
                output.add(new IpnbSvgOutputCell(StringUtil.splitByLinesKeepSeparators((String)svg), StringUtil.splitByLinesKeepSeparators((String)plainText), null));
            } else {
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    output.add(new IpnbOutOutputCell(new String[]{entry.getValue()}, null));
                }
            }
        }
    }

    private class Draft17WithOrigin
    extends Draft_17 {
        private Draft17WithOrigin() {
        }

        public Draft copyInstance() {
            return new Draft17WithOrigin();
        }

        @NotNull
        public ClientHandshakeBuilder postProcessHandshakeRequestAsClient(@NotNull ClientHandshakeBuilder request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$Draft17WithOrigin", "postProcessHandshakeRequestAsClient"));
            }
            super.postProcessHandshakeRequestAsClient(request);
            request.put("Origin", IpnbConnection.this.myURI.toString());
            ClientHandshakeBuilder clientHandshakeBuilder = request;
            if (clientHandshakeBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$Draft17WithOrigin", "postProcessHandshakeRequestAsClient"));
            }
            return clientHandshakeBuilder;
        }
    }

    private static class PyStatusContent {
        private String execution_state;

        private PyStatusContent() {
        }

        public String getExecutionState() {
            return this.execution_state;
        }
    }

    private static class PyStreamContent
    implements PyContent {
        private String text;
        private String data;
        private String name;

        private PyStreamContent() {
        }

        public String getData() {
            return this.data == null ? this.text : this.data;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class PyErrContent
    implements PyContent {
        private String ename;
        private String evalue;
        private String[] traceback;

        private PyErrContent() {
        }

        public String getEname() {
            return this.ename;
        }

        public String getEvalue() {
            return this.evalue;
        }

        public String[] getTraceback() {
            return this.traceback;
        }
    }

    private static class PyOutContent
    implements PyContent {
        private int execution_count;
        private HashMap<String, String> data;
        private JsonObject metadata;

        private PyOutContent() {
        }

        public int getExecutionCount() {
            return this.execution_count;
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public JsonObject getMetadata() {
            return this.metadata;
        }
    }

    private static interface PyContent {
    }

    private static class Message {
        private Header header;
        private JsonObject parent_header;
        private JsonObject metadata;
        private JsonObject content;

        private Message() {
        }

        public static Message create(Header header, JsonObject parentHeader, JsonObject metadata, JsonObject content) {
            Message message = new Message();
            message.header = header;
            message.parent_header = parentHeader;
            message.metadata = metadata;
            message.content = content;
            return message;
        }

        public Header getHeader() {
            return this.header;
        }

        public JsonObject getParentHeader() {
            return this.parent_header;
        }

        public JsonObject getMetadata() {
            return this.metadata;
        }

        public JsonObject getContent() {
            return this.content;
        }
    }

    private static class Header {
        private String msg_id;
        private String username;
        private String session;
        private String msg_type;

        private Header() {
        }

        @NotNull
        public static Header create(String messageId, String username, String sessionId, String messageType) {
            Header header = new Header();
            header.msg_id = messageId;
            header.username = username;
            header.session = sessionId;
            header.msg_type = messageType;
            Header header2 = header;
            if (header2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$Header", "create"));
            }
            return header2;
        }

        public String getMessageId() {
            return this.msg_id;
        }

        public String getUsername() {
            return this.username;
        }

        public String getSessionId() {
            return this.session;
        }

        public String getMessageType() {
            return this.msg_type;
        }
    }

    private static class Kernel {
        @NotNull
        private String id;

        private Kernel() {
        }

        @NotNull
        public String getId() {
            String string = this.id;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/protocol/IpnbConnection$Kernel", "getId"));
            }
            return string;
        }
    }
}

