/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.format.cells;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.format.cells.IpnbEditableCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;

public class IpnbCodeCell
extends IpnbEditableCell {
    @NotNull
    private final String myLanguage;
    @Nullable
    private Integer myPromptNumber;
    @NotNull
    private final List<IpnbOutputCell> myCellOutputs;

    public IpnbCodeCell(@NotNull String language, @NotNull String[] input, @Nullable Integer number, @NotNull List<IpnbOutputCell> cellOutputs) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/plugins/ipnb/format/cells/IpnbCodeCell", "<init>"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/plugins/ipnb/format/cells/IpnbCodeCell", "<init>"));
        }
        if (cellOutputs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellOutputs", "org/jetbrains/plugins/ipnb/format/cells/IpnbCodeCell", "<init>"));
        }
        super(input);
        this.myLanguage = language;
        this.myPromptNumber = number;
        this.myCellOutputs = cellOutputs;
    }

    @NotNull
    public String getLanguage() {
        String string = this.myLanguage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/format/cells/IpnbCodeCell", "getLanguage"));
        }
        return string;
    }

    @Nullable
    public Integer getPromptNumber() {
        return this.myPromptNumber;
    }

    public void setPromptNumber(@Nullable Integer promptNumber) {
        this.myPromptNumber = promptNumber;
    }

    @NotNull
    public List<IpnbOutputCell> getCellOutputs() {
        List<IpnbOutputCell> list = this.myCellOutputs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/format/cells/IpnbCodeCell", "getCellOutputs"));
        }
        return list;
    }

    public void removeCellOutputs() {
        this.myCellOutputs.clear();
    }

    public void addCellOutput(@NotNull IpnbOutputCell cellOutput) {
        if (cellOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellOutput", "org/jetbrains/plugins/ipnb/format/cells/IpnbCodeCell", "addCellOutput"));
        }
        this.myCellOutputs.add(cellOutput);
    }

    public Object clone() {
        return new IpnbCodeCell(this.myLanguage, Arrays.copyOf(this.getSource(), this.getSource().length), this.myPromptNumber, new ArrayList<IpnbOutputCell>(this.myCellOutputs));
    }
}

