/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.format;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.format.IpnbFile;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbHeadingCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbMarkdownCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbRawCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbErrorOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbHtmlOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbJpegOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbLatexOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbPngOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbStreamOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbSvgOutputCell;

public class IpnbParser {
    private static final Logger LOG = Logger.getInstance(IpnbParser.class);
    private static final Gson gson = IpnbParser.initGson();

    @NotNull
    private static Gson initGson() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping();
        Gson gson = builder.create();
        if (gson == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/format/IpnbParser", "initGson"));
        }
        return gson;
    }

    @NotNull
    public static IpnbFile parseIpnbFile(@NotNull CharSequence fileText, String path) throws IOException {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "org/jetbrains/plugins/ipnb/format/IpnbParser", "parseIpnbFile"));
        }
        IpnbFileRaw rawFile = (IpnbFileRaw)gson.fromJson(((Object)fileText).toString(), IpnbFileRaw.class);
        if (rawFile == null) {
            IpnbFile ipnbFile = new IpnbFile(new IpnbFileRaw(), Lists.newArrayList(), path);
            if (ipnbFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/format/IpnbParser", "parseIpnbFile"));
            }
            return ipnbFile;
        }
        ArrayList<IpnbCell> cells = new ArrayList<IpnbCell>();
        IpnbWorksheet[] worksheets = rawFile.worksheets;
        if (worksheets == null) {
            for (IpnbCellRaw rawCell : rawFile.cells) {
                cells.add(rawCell.createCell());
            }
        } else {
            for (IpnbWorksheet worksheet : worksheets) {
                List<IpnbCellRaw> rawCells = worksheet.cells;
                for (IpnbCellRaw rawCell : rawCells) {
                    cells.add(rawCell.createCell());
                }
            }
        }
        IpnbFile ipnbFile = new IpnbFile(rawFile, cells, path);
        if (ipnbFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/format/IpnbParser", "parseIpnbFile"));
        }
        return ipnbFile;
    }

    @NotNull
    public static IpnbFile parseIpnbFile(@NotNull Document document, @NotNull String path) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/ipnb/format/IpnbParser", "parseIpnbFile"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/ipnb/format/IpnbParser", "parseIpnbFile"));
        }
        IpnbFile ipnbFile = IpnbParser.parseIpnbFile(document.getImmutableCharSequence(), path);
        if (ipnbFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/format/IpnbParser", "parseIpnbFile"));
        }
        return ipnbFile;
    }

    public static void saveIpnbFile(@NotNull IpnbFilePanel ipnbPanel) {
        if (ipnbPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipnbPanel", "org/jetbrains/plugins/ipnb/format/IpnbParser", "saveIpnbFile"));
        }
        String json = IpnbParser.newDocumentText(ipnbPanel);
        if (json == null) {
            return;
        }
        IpnbParser.writeToFile(ipnbPanel.getIpnbFile().getPath(), json);
    }

    @Nullable
    public static String newDocumentText(@NotNull IpnbFilePanel ipnbPanel) {
        if (ipnbPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipnbPanel", "org/jetbrains/plugins/ipnb/format/IpnbParser", "newDocumentText"));
        }
        IpnbFile ipnbFile = ipnbPanel.getIpnbFile();
        if (ipnbFile == null) {
            return null;
        }
        for (IpnbEditablePanel panel : ipnbPanel.getIpnbPanels()) {
            if (!panel.isModified()) continue;
            panel.updateCellSource();
        }
        IpnbFileRaw fileRaw = ipnbFile.getRawFile();
        if (fileRaw.nbformat == 4) {
            fileRaw.cells.clear();
            for (IpnbCell cell : ipnbFile.getCells()) {
                fileRaw.cells.add(IpnbCellRaw.fromCell(cell, fileRaw.nbformat));
            }
        } else {
            IpnbWorksheet worksheet = new IpnbWorksheet();
            worksheet.cells.clear();
            for (IpnbCell cell : ipnbFile.getCells()) {
                worksheet.cells.add(IpnbCellRaw.fromCell(cell, fileRaw.nbformat));
            }
            fileRaw.worksheets = new IpnbWorksheet[]{worksheet};
        }
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        writer.setIndent(" ");
        gson.toJson((Object)fileRaw, fileRaw.getClass(), writer);
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(@NotNull String path, @NotNull String json) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/ipnb/format/IpnbParser", "writeToFile"));
        }
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "org/jetbrains/plugins/ipnb/format/IpnbParser", "writeToFile"));
        }
        File file = new File(path);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8").newEncoder());
            try {
                writer.write(json);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            finally {
                try {
                    writer.close();
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
        }
    }

    private static class OutputDataRaw {
        @SerializedName(value="text/plain")
        String[] text;
        @SerializedName(value="text/html")
        String[] html;
        @SerializedName(value="image/svg+xml")
        String[] svg;
        @SerializedName(value="image/png")
        String[] png;
        @SerializedName(value="image/jpeg")
        String[] jpeg;
        @SerializedName(value="text/latex")
        String[] latex;

        private OutputDataRaw() {
        }
    }

    private static class CellOutputRaw {
        String ename;
        String name;
        String evalue;
        OutputDataRaw data;
        Integer execution_count;
        String output_type;
        String png;
        String stream;
        String jpeg;
        String[] html;
        String[] latex;
        String[] svg;
        Integer prompt_number;
        String[] text;
        String[] traceback;
        Map<String, Object> metadata;

        private CellOutputRaw() {
        }

        public static CellOutputRaw fromOutput(@NotNull IpnbOutputCell outputCell, int nbformat) {
            if (outputCell == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputCell", "org/jetbrains/plugins/ipnb/format/IpnbParser$CellOutputRaw", "fromOutput"));
            }
            CellOutputRaw raw = new CellOutputRaw();
            if (!(outputCell instanceof IpnbStreamOutputCell) && !(outputCell instanceof IpnbErrorOutputCell)) {
                raw.metadata = new HashMap<String, Object>();
            }
            if (outputCell instanceof IpnbPngOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.png = new String[]{((IpnbPngOutputCell)outputCell).getBase64String()};
                    raw.data = dataRaw;
                } else {
                    raw.png = ((IpnbPngOutputCell)outputCell).getBase64String();
                }
                raw.text = outputCell.getText();
                raw.output_type = "display_data";
            } else if (outputCell instanceof IpnbSvgOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.svg = ((IpnbSvgOutputCell)outputCell).getSvg();
                    raw.data = dataRaw;
                } else {
                    raw.svg = ((IpnbSvgOutputCell)outputCell).getSvg();
                }
                raw.text = outputCell.getText();
            } else if (outputCell instanceof IpnbJpegOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.jpeg = new String[]{((IpnbJpegOutputCell)outputCell).getBase64String()};
                    raw.data = dataRaw;
                } else {
                    raw.jpeg = ((IpnbJpegOutputCell)outputCell).getBase64String();
                }
                raw.text = outputCell.getText();
            } else if (outputCell instanceof IpnbLatexOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.latex = ((IpnbLatexOutputCell)outputCell).getLatex();
                    raw.data = dataRaw;
                } else {
                    raw.latex = ((IpnbLatexOutputCell)outputCell).getLatex();
                }
                raw.prompt_number = outputCell.getPromptNumber();
                raw.text = outputCell.getText();
            } else if (outputCell instanceof IpnbStreamOutputCell) {
                if (nbformat == 4) {
                    raw.name = ((IpnbStreamOutputCell)outputCell).getStream();
                } else {
                    raw.stream = ((IpnbStreamOutputCell)outputCell).getStream();
                }
                raw.output_type = "stream";
                raw.text = outputCell.getText();
            } else if (outputCell instanceof IpnbHtmlOutputCell) {
                if (nbformat == 4) {
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.html = ((IpnbHtmlOutputCell)outputCell).getHtmls();
                    raw.data = dataRaw;
                } else {
                    raw.html = ((IpnbHtmlOutputCell)outputCell).getHtmls();
                }
                raw.output_type = nbformat == 4 ? "execute_result" : "pyout";
                raw.text = outputCell.getText();
            } else if (outputCell instanceof IpnbErrorOutputCell) {
                raw.output_type = nbformat == 4 ? "error" : "pyerr";
                raw.evalue = ((IpnbErrorOutputCell)outputCell).getEvalue();
                raw.ename = ((IpnbErrorOutputCell)outputCell).getEname();
                raw.traceback = outputCell.getText();
            } else if (outputCell instanceof IpnbOutOutputCell) {
                if (nbformat == 4) {
                    raw.execution_count = outputCell.getPromptNumber();
                    raw.output_type = "execute_result";
                    OutputDataRaw dataRaw = new OutputDataRaw();
                    dataRaw.text = outputCell.getText();
                    raw.data = dataRaw;
                } else {
                    raw.output_type = "pyout";
                    raw.prompt_number = outputCell.getPromptNumber();
                    raw.text = outputCell.getText();
                }
            }
            return raw;
        }

        public IpnbOutputCell createOutput() {
            IpnbOutputCell outputCell = this.png != null || this.data != null && this.data.png != null ? new IpnbPngOutputCell(this.png == null ? StringUtil.join((String[])this.data.png) : this.png, this.text, this.prompt_number) : (this.jpeg != null || this.data != null && this.data.jpeg != null ? new IpnbJpegOutputCell(this.jpeg == null ? StringUtil.join((String[])this.data.jpeg) : this.jpeg, this.text, this.prompt_number) : (this.svg != null || this.data != null && this.data.svg != null ? new IpnbSvgOutputCell(this.svg == null ? this.data.svg : this.svg, this.text, this.prompt_number) : (this.latex != null || this.data != null && this.data.latex != null ? new IpnbLatexOutputCell(this.latex == null ? this.data.latex : this.latex, this.prompt_number, this.text) : (this.stream != null || this.name != null ? new IpnbStreamOutputCell(this.stream == null ? this.name : this.stream, this.text, this.prompt_number) : (this.html != null || this.data != null && this.data.html != null ? new IpnbHtmlOutputCell(this.html == null ? this.data.html : this.html, this.text, this.prompt_number) : ("pyerr".equals(this.output_type) || "error".equals(this.output_type) ? new IpnbErrorOutputCell(this.evalue, this.ename, this.traceback, this.prompt_number) : ("pyout".equals(this.output_type) ? new IpnbOutOutputCell(this.text, this.prompt_number) : ("execute_result".equals(this.output_type) && this.data != null ? new IpnbOutOutputCell(this.data.text, this.execution_count) : new IpnbOutputCell(this.text, this.prompt_number)))))))));
            return outputCell;
        }
    }

    private static class IpnbCellRaw {
        String cell_type;
        Integer execution_count;
        Map<String, Object> metadata = new HashMap<String, Object>();
        Integer level;
        CellOutputRaw[] outputs;
        String[] source;
        String[] input;
        String language;
        Integer prompt_number;

        private IpnbCellRaw() {
        }

        public static IpnbCellRaw fromCell(@NotNull IpnbCell cell, int nbformat) {
            if (cell == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/format/IpnbParser$IpnbCellRaw", "fromCell"));
            }
            IpnbCellRaw raw = new IpnbCellRaw();
            if (cell instanceof IpnbMarkdownCell) {
                raw.cell_type = "markdown";
                raw.source = ((IpnbMarkdownCell)cell).getSource();
            } else if (cell instanceof IpnbCodeCell) {
                raw.cell_type = "code";
                ArrayList<CellOutputRaw> outputRaws = new ArrayList<CellOutputRaw>();
                for (IpnbOutputCell outputCell : ((IpnbCodeCell)cell).getCellOutputs()) {
                    outputRaws.add(CellOutputRaw.fromOutput(outputCell, nbformat));
                }
                raw.outputs = outputRaws.toArray(new CellOutputRaw[outputRaws.size()]);
                Integer promptNumber = ((IpnbCodeCell)cell).getPromptNumber();
                if (nbformat == 4) {
                    raw.execution_count = promptNumber != null && promptNumber >= 0 ? promptNumber : null;
                    raw.source = ((IpnbCodeCell)cell).getSource();
                } else {
                    raw.prompt_number = promptNumber != null && promptNumber >= 0 ? promptNumber : null;
                    raw.language = ((IpnbCodeCell)cell).getLanguage();
                    raw.input = ((IpnbCodeCell)cell).getSource();
                }
            } else if (cell instanceof IpnbRawCell) {
                raw.cell_type = "raw";
            } else if (cell instanceof IpnbHeadingCell) {
                raw.cell_type = "heading";
                raw.source = ((IpnbHeadingCell)cell).getSource();
                raw.level = ((IpnbHeadingCell)cell).getLevel();
            }
            return raw;
        }

        public IpnbCell createCell() {
            IpnbCell cell;
            if (this.cell_type.equals("markdown")) {
                cell = new IpnbMarkdownCell(this.source);
            } else if (this.cell_type.equals("code")) {
                ArrayList<IpnbOutputCell> outputCells = new ArrayList<IpnbOutputCell>();
                for (CellOutputRaw outputRaw : this.outputs) {
                    outputCells.add(outputRaw.createOutput());
                }
                cell = new IpnbCodeCell(this.language == null ? "python" : this.language, this.input == null ? this.source : this.input, this.prompt_number == null ? this.execution_count : this.prompt_number, outputCells);
            } else {
                cell = this.cell_type.equals("raw") ? new IpnbRawCell() : (this.cell_type.equals("heading") ? new IpnbHeadingCell(this.source, this.level) : null);
            }
            return cell;
        }
    }

    private static class IpnbWorksheet {
        List<IpnbCellRaw> cells = new ArrayList<IpnbCellRaw>();

        private IpnbWorksheet() {
        }
    }

    public static class IpnbFileRaw {
        IpnbWorksheet[] worksheets;
        List<IpnbCellRaw> cells = new ArrayList<IpnbCellRaw>();
        Map<String, Object> metadata = new HashMap<String, Object>();
        int nbformat = 3;
        int nbformat_minor;
    }
}

