/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.format;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.format.IpnbParser;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;

public class IpnbFile {
    private final IpnbParser.IpnbFileRaw myRawFile;
    private final List<IpnbCell> myCells;
    private final String myPath;

    IpnbFile(IpnbParser.IpnbFileRaw rawFile, List<IpnbCell> cells, String path) {
        this.myRawFile = rawFile;
        this.myCells = cells;
        this.myPath = path;
    }

    public List<IpnbCell> getCells() {
        return this.myCells;
    }

    public void addCell(@NotNull IpnbCell cell, int index) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/format/IpnbFile", "addCell"));
        }
        this.myCells.add(index, cell);
    }

    public void removeCell(int index) {
        this.myCells.remove(index);
    }

    public String getPath() {
        return this.myPath;
    }

    public IpnbParser.IpnbFileRaw getRawFile() {
        return this.myRawFile;
    }
}

