/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels.code;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBLabel;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeOutputPanel;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbImageOutputCell;
import sun.misc.BASE64Decoder;

public class IpnbImagePanel
extends IpnbCodeOutputPanel<IpnbImageOutputCell> {
    private static final Logger LOG = Logger.getInstance(IpnbImagePanel.class);

    public IpnbImagePanel(@NotNull IpnbImageOutputCell cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbImagePanel", "<init>"));
        }
        super(cell);
    }

    @Override
    protected JComponent createViewPanel() {
        String png = ((IpnbImageOutputCell)this.myCell).getBase64String();
        JBLabel label = new JBLabel();
        try {
            byte[] btDataFile = new BASE64Decoder().decodeBuffer(png);
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(btDataFile));
            label.setIcon((Icon)new ImageIcon(image));
        }
        catch (IOException e) {
            LOG.error("Couldn't parse image. " + e.getMessage());
        }
        label.setBackground(IpnbEditorUtil.getBackground());
        label.setOpaque(true);
        return label;
    }
}

