/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels.code;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeOutputPanel;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbErrorOutputCell;

public class IpnbErrorPanel
extends IpnbCodeOutputPanel<IpnbErrorOutputCell> {
    public IpnbErrorPanel(@NotNull IpnbErrorOutputCell cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbErrorPanel", "<init>"));
        }
        super(cell);
    }

    @Override
    protected JComponent createViewPanel() {
        String[] text = ((IpnbErrorOutputCell)this.myCell).getText();
        if (text == null) {
            return new JLabel();
        }
        ColorPane ansiColoredPane = new ColorPane();
        ansiColoredPane.appendANSI(StringUtil.join((String[])text));
        ansiColoredPane.setBackground(IpnbEditorUtil.getBackground());
        ansiColoredPane.setEditable(false);
        return ansiColoredPane;
    }

    public static class ColorPane
    extends JTextPane {
        static final Color D_Red = Color.decode("#8B0000");
        static final Color D_Magenta = JBColor.MAGENTA;
        static final Color D_Green = Color.decode("#006400");
        static final Color D_Yellow = Color.decode("#A52A2A");
        static final Color D_Cyan = Color.decode("#5AB4EB");
        static final Color cReset;
        static Color currentColor;
        String remaining = "";

        public void append(Color color, String s) {
            StyleContext styleContext = StyleContext.getDefaultStyleContext();
            AttributeSet attributeSet = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color);
            int len = this.getDocument().getLength();
            this.setCaretPosition(len);
            this.setCharacterAttributes(attributeSet, false);
            this.replaceSelection(s);
        }

        public void appendANSI(String string) {
            int position = 0;
            String addString = this.remaining + string;
            this.remaining = "";
            if (addString.length() > 0) {
                String substring;
                int index = addString.indexOf("\u001b");
                if (index == -1) {
                    this.append(currentColor, addString);
                    return;
                }
                if (index > 0) {
                    substring = addString.substring(0, index);
                    this.append(currentColor, substring);
                    position = index;
                }
                boolean continueSearch = true;
                while (continueSearch) {
                    int mIndex = addString.indexOf("m", position);
                    if (mIndex < 0) {
                        this.remaining = addString.substring(position, addString.length());
                        continueSearch = false;
                        continue;
                    }
                    substring = addString.substring(position, mIndex + 1);
                    currentColor = ColorPane.getANSIColor(substring);
                    position = mIndex + 1;
                    index = addString.indexOf("\u001b", position);
                    if (index == -1) {
                        substring = addString.substring(position, addString.length());
                        this.append(currentColor, substring);
                        continueSearch = false;
                        continue;
                    }
                    substring = addString.substring(position, index);
                    position = index;
                    this.append(currentColor, substring);
                }
            }
        }

        public static Color getANSIColor(String ANSIColor) {
            if (ANSIColor.equals("\u001b[30m") || ANSIColor.equals("\u001b[0;30m") || ANSIColor.equals("\u001b[1;30m")) {
                return JBColor.BLACK;
            }
            if (ANSIColor.equals("\u001b[31m") || ANSIColor.equals("\u001b[0;31m") || ANSIColor.equals("\u001b[1;31m")) {
                return D_Red;
            }
            if (ANSIColor.equals("\u001b[32m") || ANSIColor.equals("\u001b[0;32m") || ANSIColor.equals("\u001b[1;32m")) {
                return D_Green;
            }
            if (ANSIColor.equals("\u001b[33m") || ANSIColor.equals("\u001b[0;33m") || ANSIColor.equals("\u001b[1;33m")) {
                return D_Yellow;
            }
            if (ANSIColor.equals("\u001b[34m") || ANSIColor.equals("\u001b[0;34m") || ANSIColor.equals("\u001b[1;34m")) {
                return JBColor.BLUE;
            }
            if (ANSIColor.equals("\u001b[35m") || ANSIColor.equals("\u001b[0;35m") || ANSIColor.equals("\u001b[1;35m")) {
                return D_Magenta;
            }
            if (ANSIColor.equals("\u001b[36m") || ANSIColor.equals("\u001b[0;36m") || ANSIColor.equals("\u001b[1;36m")) {
                return D_Cyan;
            }
            if (ANSIColor.equals("\u001b[37m") || ANSIColor.equals("\u001b[0;37m") || ANSIColor.equals("\u001b[1;37m")) {
                return JBColor.WHITE;
            }
            if (ANSIColor.equals("\u001b[0m")) {
                return cReset;
            }
            return JBColor.WHITE;
        }

        static {
            currentColor = cReset = JBColor.BLACK;
        }
    }
}

