/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels.code;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbRunCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbRunCellBaseAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbRunCellInplaceAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditorPanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.HorizontalLayout;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;

public class IpnbCodeSourcePanel
extends IpnbPanel<JComponent, IpnbCodeCell>
implements IpnbEditorPanel {
    private Editor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final IpnbCodePanel myParent;
    @NotNull
    private final String mySource;

    public IpnbCodeSourcePanel(@NotNull Project project, @NotNull IpnbCodePanel parent, @NotNull IpnbCodeCell cell) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodeSourcePanel", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodeSourcePanel", "<init>"));
        }
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodeSourcePanel", "<init>"));
        }
        super(cell, new HorizontalLayout(5));
        this.myProject = project;
        this.myParent = parent;
        this.mySource = cell.getSourceAsString();
        JComponent panel = this.createViewPanel();
        this.add(panel);
    }

    @NotNull
    public IpnbCodePanel getIpnbCodePanel() {
        IpnbCodePanel ipnbCodePanel = this.myParent;
        if (ipnbCodePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodeSourcePanel", "getIpnbCodePanel"));
        }
        return ipnbCodePanel;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodeSourcePanel", "getEditor"));
        }
        return editor;
    }

    @Override
    protected JComponent createViewPanel() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(UIUtil.isUnderDarcula() ? IpnbEditorUtil.getBackground() : Gray._247);
        this.myEditor = IpnbEditorUtil.createPythonCodeEditor(this.myProject, this);
        Disposer.register((Disposable)this.myParent.getFileEditor(), (Disposable)new Disposable(){

            public void dispose() {
                EditorFactory.getInstance().releaseEditor(IpnbCodeSourcePanel.this.myEditor);
            }
        });
        JComponent component = this.myEditor.getComponent();
        final JComponent contentComponent = this.myEditor.getContentComponent();
        new IpnbRunCellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("shift ENTER")), contentComponent);
        new IpnbRunCellInplaceAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl ENTER")), contentComponent);
        contentComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                Container parent = IpnbCodeSourcePanel.this.myParent.getParent();
                if (keyCode == 27 && parent instanceof IpnbFilePanel) {
                    IpnbCodeSourcePanel.this.getIpnbCodePanel().setEditing(false);
                    parent.repaint();
                    UIUtil.requestFocus((JComponent)IpnbCodeSourcePanel.this.getIpnbCodePanel().getFileEditor().getIpnbFilePanel());
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                Container parent = IpnbCodeSourcePanel.this.myParent.getParent();
                int height = IpnbCodeSourcePanel.this.myEditor.getLineHeight() * Math.max(IpnbCodeSourcePanel.this.myEditor.getDocument().getLineCount(), 1) + 10;
                contentComponent.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                panel.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                IpnbCodeSourcePanel.this.myParent.revalidate();
                IpnbCodeSourcePanel.this.myParent.repaint();
                panel.revalidate();
                panel.repaint();
                if (parent instanceof IpnbFilePanel) {
                    IpnbFilePanel ipnbFilePanel = (IpnbFilePanel)parent;
                    ipnbFilePanel.revalidate();
                    ipnbFilePanel.repaint();
                    if (keyCode == 10 && 2 == e.getModifiers()) {
                        IpnbRunCellBaseAction.runCell(ipnbFilePanel, false);
                    } else if (keyCode == 10 && 64 == e.getModifiersEx()) {
                        IpnbRunCellBaseAction.runCell(ipnbFilePanel, true);
                    }
                }
            }
        });
        contentComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (128 == e.getModifiersEx()) {
                    return;
                }
                Container ipnbFilePanel = IpnbCodeSourcePanel.this.myParent.getParent();
                if (ipnbFilePanel instanceof IpnbFilePanel) {
                    ((IpnbFilePanel)ipnbFilePanel).setSelectedCell(IpnbCodeSourcePanel.this.myParent);
                    IpnbCodeSourcePanel.this.myParent.switchToEditing();
                }
                UIUtil.requestFocus((JComponent)contentComponent);
            }
        });
        panel.add(component);
        contentComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Container parent = IpnbCodeSourcePanel.this.myParent.getParent();
                if (parent != null) {
                    int height = IpnbCodeSourcePanel.this.myEditor.getLineHeight() * Math.max(IpnbCodeSourcePanel.this.myEditor.getDocument().getLineCount(), 1) + 10;
                    contentComponent.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                    panel.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                }
            }
        });
        contentComponent.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                Container parent = IpnbCodeSourcePanel.this.myParent.getParent();
                Component component = e.getChanged();
                if (parent != null && component instanceof IpnbFilePanel) {
                    int height = IpnbCodeSourcePanel.this.myEditor.getLineHeight() * Math.max(IpnbCodeSourcePanel.this.myEditor.getDocument().getLineCount(), 1) + 10;
                    contentComponent.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                    panel.setPreferredSize(new Dimension(parent.getWidth() - 300, height));
                    panel.revalidate();
                    panel.repaint();
                    parent.repaint();
                }
            }
        });
        return panel;
    }
}

