/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels.code;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.configuration.IpnbConnectionManager;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeOutputPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeSourcePanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbErrorPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbHtmlPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbImagePanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbLatexPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbStreamPanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbErrorOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbHtmlOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbImageOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbLatexOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbStreamOutputCell;

public class IpnbCodePanel
extends IpnbEditablePanel<JComponent, IpnbCodeCell> {
    private final Project myProject;
    private final IpnbFileEditor myParent;
    private IpnbCodeSourcePanel myCodeSourcePanel;
    private final List<IpnbPanel> myOutputPanels;

    public IpnbCodePanel(@NotNull Project project, @NotNull IpnbFileEditor parent, @NotNull IpnbCodeCell cell) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel", "<init>"));
        }
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel", "<init>"));
        }
        super(cell, new BorderLayout());
        this.myOutputPanels = Lists.newArrayList();
        this.myProject = project;
        this.myParent = parent;
        this.myViewPanel = this.createViewPanel();
        this.add(this.myViewPanel);
    }

    public IpnbFileEditor getFileEditor() {
        return this.myParent;
    }

    public Editor getEditor() {
        return this.myCodeSourcePanel.getEditor();
    }

    @Override
    public void addPromptPanel(@NotNull JComponent parent, Integer promptNumber, @NotNull IpnbEditorUtil.PromptType promptType, @NotNull JComponent component) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel", "addPromptPanel"));
        }
        if (promptType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promptType", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel", "addPromptPanel"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel", "addPromptPanel"));
        }
        super.addPromptPanel(parent, promptNumber, promptType, component);
        if (component instanceof IpnbPanel) {
            this.myOutputPanels.add((IpnbPanel)component);
        }
    }

    @Override
    protected JComponent createViewPanel() {
        JPanel mainPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, true, false));
        mainPanel.setBackground(IpnbEditorUtil.getBackground());
        this.myCodeSourcePanel = new IpnbCodeSourcePanel(this.myProject, this, (IpnbCodeCell)this.myCell);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(IpnbEditorUtil.getBackground());
        this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), IpnbEditorUtil.PromptType.In, this.myCodeSourcePanel);
        mainPanel.add(panel);
        for (IpnbOutputCell outputCell : ((IpnbCodeCell)this.myCell).getCellOutputs()) {
            this.addOutputPanel(mainPanel, outputCell, true);
        }
        return mainPanel;
    }

    private void addOutputPanel(@NotNull JComponent mainPanel, @NotNull IpnbOutputCell outputCell, boolean addPrompt) {
        if (mainPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainPanel", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel", "addOutputPanel"));
        }
        if (outputCell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputCell", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel", "addOutputPanel"));
        }
        IpnbEditorUtil.PromptType promptType = addPrompt ? IpnbEditorUtil.PromptType.Out : IpnbEditorUtil.PromptType.None;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(IpnbEditorUtil.getBackground());
        if (outputCell instanceof IpnbImageOutputCell) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbImagePanel((IpnbImageOutputCell)outputCell));
        } else if (outputCell instanceof IpnbHtmlOutputCell) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbHtmlPanel((IpnbHtmlOutputCell)outputCell));
        } else if (outputCell instanceof IpnbLatexOutputCell) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbLatexPanel((IpnbLatexOutputCell)outputCell));
        } else if (outputCell instanceof IpnbErrorOutputCell) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbErrorPanel((IpnbErrorOutputCell)outputCell));
        } else if (outputCell instanceof IpnbStreamOutputCell) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), IpnbEditorUtil.PromptType.None, new IpnbStreamPanel((IpnbStreamOutputCell)outputCell));
        } else if (outputCell.getSourceAsString() != null) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbCodeOutputPanel<IpnbOutputCell>(outputCell));
        }
        mainPanel.add(panel);
    }

    @Override
    public void switchToEditing() {
        this.setEditing(true);
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint();
        }
        UIUtil.requestFocus((JComponent)this.myCodeSourcePanel.getEditor().getContentComponent());
    }

    @Override
    public void runCell() {
        super.runCell();
        this.updateCellSource();
        ((IpnbCodeCell)this.myCell).setPromptNumber(-1);
        this.updatePanel(((IpnbCodeCell)this.myCell).getCellOutputs());
        IpnbConnectionManager connectionManager = IpnbConnectionManager.getInstance(this.myProject);
        connectionManager.executeCell(this);
        this.setEditing(false);
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void updateCellSource() {
        Document document = this.myCodeSourcePanel.getEditor().getDocument();
        String text = document.getText();
        ((IpnbCodeCell)this.myCell).setSource(StringUtil.splitByLinesKeepSeparators((String)text));
    }

    public void updatePanel(final @NotNull List<IpnbOutputCell> outputContent) {
        if (outputContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputContent", "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel", "updatePanel"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ((IpnbCodeCell)IpnbCodePanel.this.myCell).removeCellOutputs();
                IpnbCodePanel.this.myViewPanel.removeAll();
                JPanel panel = new JPanel(new GridBagLayout());
                panel.setBackground(IpnbEditorUtil.getBackground());
                IpnbCodePanel.this.addPromptPanel(panel, ((IpnbCodeCell)IpnbCodePanel.this.myCell).getPromptNumber(), IpnbEditorUtil.PromptType.In, IpnbCodePanel.this.myCodeSourcePanel);
                IpnbCodePanel.this.myViewPanel.add(panel);
                for (IpnbOutputCell output : outputContent) {
                    ((IpnbCodeCell)IpnbCodePanel.this.myCell).addCellOutput(output);
                    IpnbCodePanel.this.addOutputPanel(IpnbCodePanel.this.myViewPanel, output, true);
                }
                IpnbFilePanel filePanel = IpnbCodePanel.this.myParent.getIpnbFilePanel();
                filePanel.revalidate();
                filePanel.repaint();
            }
        });
    }

    @Override
    protected Object clone() {
        return new IpnbCodePanel(this.myProject, this.myParent, (IpnbCodeCell)((IpnbCodeCell)this.myCell).clone());
    }
}

