/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels;

import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SnugglePackage;
import uk.ac.ed.ph.snuggletex.definitions.Globals;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EqnArrayHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathInterpretation;
import uk.ac.ed.ph.snuggletex.semantics.MathOperatorInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;

public final class IpnbTexPackageDefinitions {
    private static final SnugglePackage ourPackage;
    private static String ourMathCharacters;

    public static SnugglePackage getPackage() {
        return ourPackage;
    }

    static {
        ourMathCharacters = "org/jetbrains/plugins/ipnb/math-characters.txt";
        ourPackage = new SnugglePackage("Ipnb");
        ourPackage.addComplexCommandSameArgMode("dot", false, 1, Globals.MATH_MODE_ONLY, new CommandHandler(){

            public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token) throws SnuggleParseException {
                List content = token.getArguments()[0].getContents();
                Element result = builder.appendMathMLElement(parentElement, "mover");
                builder.handleMathTokensAsSingleElement(result, content);
                builder.appendMathMLOperatorElement(result, "\u02d9");
            }
        }, null);
        ourPackage.addComplexCommandSameArgMode("pi", false, 0, Globals.MATH_MODE_ONLY, new CommandHandler(){

            public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token) throws SnuggleParseException {
                builder.appendMathMLOperatorElement(parentElement, "\u03c0");
            }
        }, null);
        ourPackage.addEnvironment("eqnarray", Globals.ALL_MODES, LaTeXMode.MATH, Interpretation.TABULAR, (EnvironmentHandler)new EqnArrayHandler(), TextFlowContext.START_NEW_XHTML_BLOCK);
        ourPackage.addSimpleMathCommand("lt", new MathInterpretation[]{new MathOperatorInterpretation("<")});
        ourPackage.addSimpleMathCommand("gt", new MathInterpretation[]{new MathOperatorInterpretation(">")});
        ourPackage.loadMathCharacterDefinitions(ourMathCharacters);
    }
}

