/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels;

import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.IpnbUtils;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbMarkdownCell;

public class IpnbMarkdownPanel
extends IpnbEditablePanel<JEditorPane, IpnbMarkdownCell> {
    public IpnbMarkdownPanel(@NotNull IpnbMarkdownCell cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/IpnbMarkdownPanel", "<init>"));
        }
        super(cell);
        this.initPanel();
    }

    @Override
    protected String getRawCellText() {
        return ((IpnbMarkdownCell)this.myCell).getSourceAsString();
    }

    @Override
    protected JEditorPane createViewPanel() {
        return IpnbUtils.createLatexPane(((IpnbMarkdownCell)this.myCell).getSourceAsString());
    }

    @Override
    public void updateCellView() {
        this.removeAll();
        this.initPanel();
    }

    @Override
    protected Object clone() {
        return new IpnbMarkdownPanel((IpnbMarkdownCell)((IpnbMarkdownCell)this.myCell).clone());
    }
}

