/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels;

import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbCutCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbDeleteCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbPasteCellAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbHeadingPanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbMarkdownPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.IpnbFile;
import org.jetbrains.plugins.ipnb.format.IpnbParser;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbHeadingCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbMarkdownCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;

public class IpnbFilePanel
extends JPanel
implements Scrollable,
DataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(IpnbFilePanel.class);
    private final DocumentAdapter myDocumentListener;
    private Document myDocument;
    private IpnbFile myIpnbFile;
    private Project myProject;
    @NotNull
    private IpnbFileEditor myParent;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final IpnbFileEditor.CellSelectionListener myListener;
    private final List<IpnbEditablePanel> myIpnbPanels;
    @Nullable
    private IpnbEditablePanel mySelectedCell;
    boolean switchToEditing;
    private IpnbEditablePanel myBufferPanel;
    private int myInitialSelection;

    public IpnbFilePanel(@NotNull Project project, @NotNull IpnbFileEditor parent, @NotNull VirtualFile vFile, @NotNull IpnbFileEditor.CellSelectionListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "<init>"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "<init>"));
        }
        super((LayoutManager)new VerticalFlowLayout(0, 100, 5, true, false));
        this.myIpnbPanels = Lists.newArrayList();
        this.switchToEditing = false;
        this.myInitialSelection = 0;
        this.myProject = project;
        this.myParent = parent;
        this.myVirtualFile = vFile;
        this.myListener = listener;
        this.setBackground(IpnbEditorUtil.getBackground());
        final Alarm alarm = new Alarm();
        this.myDocumentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                alarm.cancelAllRequests();
                alarm.addRequest((Runnable)new MySynchronizeRequest(), 10, ModalityState.stateForComponent((Component)IpnbFilePanel.this));
            }
        };
        this.myDocument = this.myParent.getDocument();
        this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                IpnbFilePanel.this.readFromFile(true);
                IpnbFilePanel.this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        IpnbFilePanel.this.updateCellSelection(e);
                    }
                });
                IpnbFilePanel.this.setFocusable(true);
            }
        }, 10, ModalityState.stateForComponent((Component)this));
        UIUtil.requestFocus((JComponent)this);
    }

    public void dispose() {
        this.myDocument.removeDocumentListener((DocumentListener)this.myDocumentListener);
    }

    private void readFromFile(boolean showError) {
        try {
            this.myIpnbPanels.clear();
            this.mySelectedCell = null;
            this.myIpnbFile = IpnbParser.parseIpnbFile(this.myDocument, this.myVirtualFile.getPath());
            if (this.myIpnbFile.getCells().isEmpty()) {
                CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                IpnbFilePanel.this.createAndAddCell(true);
                                IpnbFilePanel.this.saveToFile();
                            }
                        });
                    }
                });
            }
        }
        catch (IOException e) {
            if (showError) {
                Messages.showErrorDialog((Project)this.getProject(), (String)e.getMessage(), (String)("Can't open " + this.myVirtualFile.getPath()));
            }
            LOG.error(e.getMessage(), new String[]{"Can't open " + this.myVirtualFile.getPath()});
        }
        this.layoutFile();
    }

    public List<IpnbEditablePanel> getIpnbPanels() {
        return this.myIpnbPanels;
    }

    private void layoutFile() {
        List<IpnbCell> cells = this.myIpnbFile.getCells();
        for (IpnbCell cell : cells) {
            this.addCellToPanel(cell);
        }
        if (this.myInitialSelection >= 0 && this.myIpnbPanels.size() > this.myInitialSelection) {
            IpnbEditablePanel toSelect = this.myIpnbPanels.get(this.myInitialSelection);
            this.setSelectedCell(toSelect);
            if (this.switchToEditing) {
                toSelect.switchToEditing();
                this.switchToEditing = false;
            }
        }
        this.add(IpnbFilePanel.createEmptyPanel());
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (IpnbFilePanel.this.mySelectedCell != null) {
                    IpnbFilePanel.this.myParent.updateScrollPosition(IpnbFilePanel.this.mySelectedCell);
                }
            }
        });
    }

    private void addCellToPanel(IpnbCell cell) {
        if (cell instanceof IpnbCodeCell) {
            IpnbCodePanel panel = new IpnbCodePanel(this.myProject, this.myParent, (IpnbCodeCell)cell);
            this.add(panel);
            this.myIpnbPanels.add(panel);
        } else if (cell instanceof IpnbMarkdownCell) {
            IpnbMarkdownPanel panel = new IpnbMarkdownPanel((IpnbMarkdownCell)cell);
            this.addComponent(panel);
        } else if (cell instanceof IpnbHeadingCell) {
            IpnbHeadingPanel panel = new IpnbHeadingPanel((IpnbHeadingCell)cell);
            this.addComponent(panel);
        } else {
            throw new UnsupportedOperationException(cell.getClass().toString());
        }
    }

    public void createAndAddCell(boolean below) {
        IpnbCodeCell cell = new IpnbCodeCell("python", new String[]{""}, null, new ArrayList<IpnbOutputCell>());
        IpnbCodePanel codePanel = new IpnbCodePanel(this.myProject, this.myParent, cell);
        this.addCell(codePanel, below);
    }

    private void addCell(@NotNull IpnbEditablePanel panel, boolean below) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "addCell"));
        }
        IpnbEditablePanel selectedCell = this.getSelectedCell();
        int index = this.myIpnbPanels.indexOf(selectedCell);
        if (below) {
            ++index;
        }
        IpnbCell cell = panel.getCell();
        this.myIpnbFile.addCell(cell, index);
        this.myIpnbPanels.add(index, panel);
        this.setSelectedCell(panel);
    }

    public void cutCell() {
        this.myBufferPanel = this.getSelectedCell();
        if (this.myBufferPanel == null) {
            return;
        }
        this.deleteSelectedCell();
    }

    public void moveCell(boolean down) {
        int siblingIndex;
        IpnbEditablePanel selectedCell = this.getSelectedCell();
        if (selectedCell == null) {
            return;
        }
        int index = this.getSelectedIndex();
        int n = siblingIndex = down ? index + 1 : index - 1;
        if (this.myIpnbPanels.size() <= siblingIndex && down) {
            return;
        }
        if (siblingIndex < 0 && !down) {
            return;
        }
        if (down) {
            this.deleteSelectedCell();
            IpnbCell cell = selectedCell.getCell();
            this.myIpnbFile.addCell(cell, index + 1);
            this.myIpnbPanels.add(index + 1, selectedCell);
            this.selectPrev(selectedCell);
            this.setSelectedCell(selectedCell);
        } else {
            IpnbEditablePanel siblingPanel = this.myIpnbPanels.get(siblingIndex);
            this.deleteCell(siblingPanel);
            this.addCell(siblingPanel, true);
            this.setSelectedCell(selectedCell);
        }
        this.saveToFile();
    }

    public void deleteSelectedCell() {
        IpnbEditablePanel cell = this.getSelectedCell();
        if (cell != null) {
            this.deleteCell(cell);
        }
    }

    private boolean deleteCell(@NotNull IpnbEditablePanel cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "deleteCell"));
        }
        int index = this.myIpnbPanels.indexOf(cell);
        if (index < 0) {
            return true;
        }
        this.myIpnbPanels.remove(index);
        this.myIpnbFile.removeCell(index);
        if (this.myIpnbFile.getCells().isEmpty()) {
            IpnbCodeCell newCell = new IpnbCodeCell("python", new String[]{""}, null, new ArrayList<IpnbOutputCell>());
            IpnbCodePanel codePanel = new IpnbCodePanel(this.myProject, this.myParent, newCell);
            this.addCell(codePanel, false);
        }
        return false;
    }

    public void saveToFile() {
        String oldText = this.myDocument.getText();
        String newText = IpnbParser.newDocumentText(this);
        if (newText == null) {
            return;
        }
        if (oldText.equals(newText)) {
            new Alarm().addRequest((Runnable)new MySynchronizeRequest(), 10, ModalityState.stateForComponent((Component)this));
            return;
        }
        try {
            ReplaceInfo replaceInfo = IpnbFilePanel.findFragmentToChange(oldText, newText);
            if (replaceInfo.getStartOffset() != -1) {
                this.myDocument.replaceString(replaceInfo.getStartOffset(), replaceInfo.getEndOffset(), (CharSequence)replaceInfo.getReplacement());
            }
        }
        catch (Exception e) {
            this.myDocument.replaceString(0, oldText.length(), (CharSequence)newText);
        }
    }

    public static ReplaceInfo findFragmentToChange(@NotNull String oldText, @NotNull String newText) {
        char c2;
        char c1;
        int idxInNew;
        int endOffset;
        int startOffset;
        if (oldText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldText", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "findFragmentToChange"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "findFragmentToChange"));
        }
        if (oldText.equals(newText)) {
            return new ReplaceInfo(-1, -1, null);
        }
        int oldLength = oldText.length();
        int newLength = newText.length();
        for (startOffset = 0; startOffset < oldLength && startOffset < newLength && oldText.charAt(startOffset) == newText.charAt(startOffset); ++startOffset) {
        }
        for (endOffset = oldLength; endOffset > startOffset && (idxInNew = newLength - (oldLength - endOffset) - 1) >= startOffset && (c1 = oldText.charAt(endOffset - 1)) == (c2 = newText.charAt(idxInNew)); --endOffset) {
        }
        return new ReplaceInfo(startOffset, endOffset, newText.substring(startOffset, newLength - (oldLength - endOffset)));
    }

    public void copyCell() {
        this.myBufferPanel = this.getSelectedCell();
    }

    public void pasteCell() {
        if (this.myBufferPanel == null) {
            return;
        }
        IpnbEditablePanel editablePanel = (IpnbEditablePanel)this.myBufferPanel.clone();
        this.addCell(editablePanel, true);
    }

    public void replaceComponent(final @NotNull IpnbEditablePanel from, final @NotNull IpnbCell cell) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "replaceComponent"));
        }
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "replaceComponent"));
        }
        CommandProcessor.getInstance().executeCommand(this.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        IpnbEditablePanel panel;
                        int index = IpnbFilePanel.this.myIpnbPanels.indexOf(from);
                        if (cell instanceof IpnbCodeCell) {
                            panel = new IpnbCodePanel(IpnbFilePanel.this.myProject, IpnbFilePanel.this.myParent, (IpnbCodeCell)cell);
                        } else if (cell instanceof IpnbMarkdownCell) {
                            panel = new IpnbMarkdownPanel((IpnbMarkdownCell)cell);
                        } else if (cell instanceof IpnbHeadingCell) {
                            panel = new IpnbHeadingPanel((IpnbHeadingCell)cell);
                        } else {
                            throw new UnsupportedOperationException(cell.getClass().toString());
                        }
                        if (index >= 0) {
                            IpnbFilePanel.this.myIpnbFile.removeCell(index);
                            IpnbFilePanel.this.myIpnbFile.addCell(cell, index);
                            IpnbFilePanel.this.myIpnbPanels.remove(index);
                            IpnbFilePanel.this.myIpnbPanels.add(index, panel);
                        }
                        if (from instanceof IpnbCodePanel) {
                            IpnbFilePanel.this.switchToEditing = true;
                        }
                        IpnbFilePanel.this.setSelectedCell(panel);
                        IpnbFilePanel.this.saveToFile();
                    }
                });
            }
        }, "Ipnb.changeCellType", new Object());
    }

    private void addComponent(@NotNull IpnbEditablePanel comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "addComponent"));
        }
        this.add(comp);
        this.myIpnbPanels.add(comp);
    }

    private static JPanel createEmptyPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(IpnbEditorUtil.getBackground());
        return panel;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this.mySelectedCell != null && e.getID() == 401) {
            if (e.getKeyCode() == 10) {
                this.mySelectedCell.switchToEditing();
                this.repaint();
            }
            if (e.getKeyCode() == 38) {
                this.selectPrev(this.mySelectedCell);
            } else if (e.getKeyCode() == 40) {
                this.selectNext(this.mySelectedCell);
            } else if (e.getKeyCode() == 127) {
                if (!this.mySelectedCell.isEditing()) {
                    IpnbDeleteCellAction.deleteCell(this);
                }
            } else if (e.getModifiers() == 2) {
                if (e.getKeyCode() == 88) {
                    if (!this.mySelectedCell.isEditing()) {
                        IpnbCutCellAction.cutCell(this);
                    }
                } else if (e.getKeyCode() == 67) {
                    if (!this.mySelectedCell.isEditing()) {
                        this.copyCell();
                    }
                } else if (e.getKeyCode() == 86 && !this.mySelectedCell.isEditing()) {
                    IpnbPasteCellAction.pasteCell(this);
                }
            } else {
                this.getParent().dispatchEvent(e);
            }
        }
    }

    public void selectPrev(@NotNull IpnbEditablePanel cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "selectPrev"));
        }
        int index = this.myIpnbPanels.indexOf(cell);
        if (index > 0) {
            this.setSelectedCell(this.myIpnbPanels.get(index - 1));
        }
    }

    public void selectNext(@NotNull IpnbEditablePanel cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "selectNext"));
        }
        int index = this.myIpnbPanels.indexOf(cell);
        if (index < this.myIpnbPanels.size() - 1) {
            this.setSelectedCell(this.myIpnbPanels.get(index + 1));
        }
    }

    public void selectNextOrPrev(@NotNull IpnbEditablePanel cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "selectNextOrPrev"));
        }
        int index = this.myIpnbPanels.indexOf(cell);
        if (index < this.myIpnbPanels.size() - 1) {
            this.setSelectedCell(this.myIpnbPanels.get(index + 1));
        } else if (index > 0) {
            this.setSelectedCell(this.myIpnbPanels.get(index - 1));
        } else {
            this.mySelectedCell = null;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mySelectedCell != null) {
            g.setColor((Color)(this.mySelectedCell.isEditing() ? JBColor.GREEN : JBColor.GRAY));
            g.drawRoundRect(this.mySelectedCell.getX() - 50, this.mySelectedCell.getTop() - 1, this.mySelectedCell.getWidth() + 145 - IpnbEditorUtil.PROMPT_SIZE.width, this.mySelectedCell.getHeight() + 2, 5, 5);
        }
    }

    private void updateCellSelection(MouseEvent e) {
        IpnbEditablePanel ipnbPanel;
        if (e.getClickCount() > 0 && (ipnbPanel = this.getIpnbPanelByClick(e.getPoint())) != null) {
            ipnbPanel.setEditing(false);
            ipnbPanel.requestFocus();
            this.repaint();
            this.setSelectedCell(ipnbPanel);
        }
    }

    public void setInitialPosition(int index) {
        this.myInitialSelection = index;
    }

    public void setSelectedCell(@NotNull IpnbEditablePanel ipnbPanel) {
        if (ipnbPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipnbPanel", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "setSelectedCell"));
        }
        if (ipnbPanel.equals(this.mySelectedCell)) {
            return;
        }
        if (this.mySelectedCell != null) {
            this.mySelectedCell.setEditing(false);
        }
        this.mySelectedCell = ipnbPanel;
        this.revalidate();
        UIUtil.requestFocus((JComponent)this);
        this.repaint();
        if (ipnbPanel.getBounds().getHeight() != 0.0) {
            this.myListener.selectionChanged(ipnbPanel);
        }
    }

    @Nullable
    public IpnbEditablePanel getSelectedCell() {
        return this.mySelectedCell;
    }

    public int getSelectedIndex() {
        IpnbEditablePanel selectedCell = this.getSelectedCell();
        return this.myIpnbPanels.indexOf(selectedCell);
    }

    @Nullable
    private IpnbEditablePanel getIpnbPanelByClick(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "org/jetbrains/plugins/ipnb/editor/panels/IpnbFilePanel", "getIpnbPanelByClick"));
        }
        for (IpnbEditablePanel c : this.myIpnbPanels) {
            if (!c.contains(point.y)) continue;
            return c;
        }
        return null;
    }

    public IpnbFile getIpnbFile() {
        return this.myIpnbFile;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Nullable
    public Object getData(String dataId) {
        IpnbEditablePanel cell = this.getSelectedCell();
        if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId) && cell instanceof IpnbCodePanel) {
            return ((IpnbCodePanel)cell).getEditor();
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    private class MySynchronizeRequest
    implements Runnable {
        private MySynchronizeRequest() {
        }

        @Override
        public void run() {
            Project project = IpnbFilePanel.this.getProject();
            if (project.isDisposed()) {
                return;
            }
            if (Disposer.isDisposed((Disposable)IpnbFilePanel.this.myParent)) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(IpnbFilePanel.this.myDocument);
            IpnbEditablePanel selectedCell = IpnbFilePanel.this.getSelectedCell();
            int index = IpnbFilePanel.this.myIpnbPanels.indexOf(selectedCell);
            IpnbFilePanel.this.myInitialSelection = index >= 0 && index < IpnbFilePanel.this.myIpnbPanels.size() ? index : IpnbFilePanel.this.myIpnbPanels.size() - 1;
            IpnbFilePanel.this.removeAll();
            IpnbFilePanel.this.readFromFile(false);
        }
    }

    public static final class ReplaceInfo {
        private final int myStartOffset;
        private final int myEndOffset;
        private final String myReplacement;

        public ReplaceInfo(int startOffset, int endOffset, String replacement) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myReplacement = replacement;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myEndOffset;
        }

        public String getReplacement() {
            return this.myReplacement;
        }
    }
}

