/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbPanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbEditableCell;

public abstract class IpnbEditablePanel<T extends JComponent, K extends IpnbEditableCell>
extends IpnbPanel<T, K> {
    private static final Logger LOG = Logger.getInstance(IpnbEditablePanel.class);
    private boolean myEditing;
    protected JTextArea myEditablePanel;
    public static final String EDITABLE_PANEL = "Editable panel";
    public static final String VIEW_PANEL = "View panel";

    public IpnbEditablePanel(@NotNull K cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/IpnbEditablePanel", "<init>"));
        }
        super(cell);
    }

    public IpnbEditablePanel(@NotNull K cell, @NotNull LayoutManager layoutManager) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "org/jetbrains/plugins/ipnb/editor/panels/IpnbEditablePanel", "<init>"));
        }
        if (layoutManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutManager", "org/jetbrains/plugins/ipnb/editor/panels/IpnbEditablePanel", "<init>"));
        }
        super(cell, layoutManager);
    }

    protected void initPanel() {
        this.addViewPanel();
        this.addEditablePanel();
    }

    private void addEditablePanel() {
        this.myEditablePanel = this.createEditablePanel();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName(EDITABLE_PANEL);
        panel.setBackground(IpnbEditorUtil.getBackground());
        this.addPromptPanel(panel, null, IpnbEditorUtil.PromptType.None, this.myEditablePanel);
        this.add((Component)panel, EDITABLE_PANEL);
    }

    private void addViewPanel() {
        this.myViewPanel = this.createViewPanel();
        this.myViewPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Container parent = IpnbEditablePanel.this.getParent();
                MouseEvent parentEvent = SwingUtilities.convertMouseEvent(IpnbEditablePanel.this.myViewPanel, e, parent);
                parent.dispatchEvent(parentEvent);
                if (e.getClickCount() == 2) {
                    IpnbEditablePanel.this.switchToEditing();
                }
            }
        });
        this.myViewPanel.setName(VIEW_PANEL);
        JPanel panel = new JPanel(new GridBagLayout());
        this.addPromptPanel(panel, null, IpnbEditorUtil.PromptType.None, this.myViewPanel);
        panel.setBackground(IpnbEditorUtil.getBackground());
        this.add((Component)panel, VIEW_PANEL);
    }

    public void addPromptPanel(@NotNull JComponent parent, Integer promptNumber, @NotNull IpnbEditorUtil.PromptType promptType, @NotNull JComponent component) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/ipnb/editor/panels/IpnbEditablePanel", "addPromptPanel"));
        }
        if (promptType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promptType", "org/jetbrains/plugins/ipnb/editor/panels/IpnbEditablePanel", "addPromptPanel"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/plugins/ipnb/editor/panels/IpnbEditablePanel", "addPromptPanel"));
        }
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 18;
        JComponent promptComponent = IpnbEditorUtil.createPromptComponent(promptNumber, promptType);
        c.insets = new Insets(2, 2, 2, 5);
        parent.add((Component)promptComponent, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 10;
        parent.add((Component)component, c);
    }

    public void switchToEditing() {
        this.setEditing(true);
        LayoutManager layout = this.getLayout();
        if (layout instanceof CardLayout) {
            ((CardLayout)layout).show(this, EDITABLE_PANEL);
            UIUtil.requestFocus((JComponent)this.myEditablePanel);
        }
    }

    public boolean isModified() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            String name = component.getName();
            if (!component.isVisible() || !EDITABLE_PANEL.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected String getRawCellText() {
        return "";
    }

    public void runCell() {
        LayoutManager layout = this.getLayout();
        if (layout instanceof CardLayout) {
            this.updateCellSource();
            this.updateCellView();
            ((CardLayout)layout).show(this, VIEW_PANEL);
            this.setEditing(false);
        }
    }

    private JTextArea createEditablePanel() {
        final JTextArea textArea = new JTextArea(this.getRawCellText());
        textArea.setLineWrap(true);
        textArea.setEditable(true);
        textArea.setBorder(BorderFactory.createLineBorder((Color)JBColor.lightGray));
        textArea.setBackground(IpnbEditorUtil.getEditablePanelBackground());
        textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    IpnbEditablePanel.this.setEditing(true);
                    Container parent = IpnbEditablePanel.this.getParent();
                    parent.repaint();
                    if (parent instanceof IpnbFilePanel) {
                        ((IpnbFilePanel)parent).setSelectedCell(IpnbEditablePanel.this);
                        textArea.requestFocus();
                    }
                }
            }
        });
        textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    IpnbEditablePanel.this.setEditing(false);
                    Container parent = IpnbEditablePanel.this.getParent();
                    if (parent instanceof IpnbFilePanel) {
                        parent.repaint();
                        UIUtil.requestFocus((JComponent)((IpnbFilePanel)parent));
                    }
                }
            }
        });
        return textArea;
    }

    public boolean contains(int y) {
        return y >= this.getTop() && y <= this.getBottom();
    }

    public int getTop() {
        return this.getY();
    }

    public int getBottom() {
        return this.getTop() + this.getHeight();
    }

    public boolean isEditing() {
        return this.myEditing;
    }

    public void setEditing(boolean editing) {
        this.myEditing = editing;
    }

    public void updateCellView() {
    }

    public void updateCellSource() {
        String text = this.myEditablePanel.getText();
        ((IpnbEditableCell)this.myCell).setSource(StringUtil.splitByLinesKeepSeparators((String)(text != null ? text : "")));
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    public K getCell() {
        return (K)((IpnbEditableCell)this.myCell);
    }
}

