/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.format.IpnbParser;

public class IpnbSaveAction
extends AnAction {
    public IpnbSaveAction() {
        super(AllIcons.Actions.Menu_saveall);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ipnb/editor/actions/IpnbSaveAction", "actionPerformed"));
        }
        DataContext context = event.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
        if (editor instanceof IpnbFileEditor) {
            IpnbSaveAction.saveAndCheckpoint((IpnbFileEditor)editor);
        }
    }

    public static void saveAndCheckpoint(@NotNull IpnbFileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/ipnb/editor/actions/IpnbSaveAction", "saveAndCheckpoint"));
        }
        IpnbFilePanel filePanel = editor.getIpnbFilePanel();
        IpnbParser.saveIpnbFile(filePanel);
        VirtualFile file = editor.getVirtualFile();
        file.refresh(false, false);
    }
}

