/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;

public abstract class IpnbRunCellBaseAction
extends AnAction {
    public IpnbRunCellBaseAction() {
        super(AllIcons.General.Run);
    }

    public static void runCell(final @NotNull IpnbFilePanel ipnbFilePanel, boolean selectNext) {
        if (ipnbFilePanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipnbFilePanel", "org/jetbrains/plugins/ipnb/editor/actions/IpnbRunCellBaseAction", "runCell"));
        }
        IpnbEditablePanel cell = ipnbFilePanel.getSelectedCell();
        if (cell == null) {
            return;
        }
        cell.runCell();
        if (selectNext) {
            int index = ipnbFilePanel.getSelectedIndex();
            if (ipnbFilePanel.getIpnbPanels().size() - 1 == index) {
                ipnbFilePanel.createAndAddCell(true);
                CommandProcessor.getInstance().executeCommand(ipnbFilePanel.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                ipnbFilePanel.saveToFile();
                            }
                        });
                    }
                }, "Ipnb.runCell", new Object());
            }
            ipnbFilePanel.selectNext(cell);
        }
        ipnbFilePanel.revalidate();
        ipnbFilePanel.repaint();
        ipnbFilePanel.requestFocus();
    }
}

