/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbEditableCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbHeadingCell;

public class IpnbHeadingCellActionBase
extends AnAction {
    private final int myLevel;

    public IpnbHeadingCellActionBase(int level) {
        this.myLevel = level;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ipnb/editor/actions/IpnbHeadingCellActionBase", "actionPerformed"));
        }
        DataContext context = event.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
        if (editor instanceof IpnbFileEditor) {
            this.changeTypeToHeading((IpnbFileEditor)editor);
        }
    }

    public void changeTypeToHeading(@NotNull IpnbFileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/ipnb/editor/actions/IpnbHeadingCellActionBase", "changeTypeToHeading"));
        }
        IpnbFilePanel filePanel = editor.getIpnbFilePanel();
        IpnbEditablePanel selectedCell = filePanel.getSelectedCell();
        if (selectedCell == null) {
            return;
        }
        IpnbCell cell = selectedCell.getCell();
        List<IpnbCell> cells = filePanel.getIpnbFile().getCells();
        int index = cells.indexOf(selectedCell.getCell());
        IpnbHeadingCell heading = new IpnbHeadingCell(((IpnbEditableCell)cell).getSource(), this.myLevel);
        if (index >= 0) {
            cells.set(index, heading);
        }
        filePanel.replaceComponent(selectedCell, heading);
    }
}

