/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor;

import com.google.common.collect.Lists;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.MatteBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorState;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbAddCellBelowAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbCopyCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbCutCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading1CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading2CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading3CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading4CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading5CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHeading6CellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbPasteCellAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbRunCellBaseAction;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbSaveAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbHeadingPanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbMarkdownPanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.IpnbParser;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbHeadingCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbMarkdownCell;

public class IpnbFileEditor
extends UserDataHolderBase
implements FileEditor {
    private final VirtualFile myFile;
    private final String myName;
    private final JComponent myEditorPanel;
    private final IpnbFilePanel myIpnbFilePanel;
    private final Document myDocument;
    private ComboBox myCellTypeCombo;
    private static final String codeCellType = "Code";
    private static final String markdownCellType = "Markdown";
    private static final String headingCellType = "Heading ";
    private static final String rawNBCellType = "Raw NBConvert";
    private static final String[] ourCellTypes = new String[]{"Code", "Markdown", "Heading 1", "Heading 2", "Heading 3", "Heading 4", "Heading 5", "Heading 6"};
    private JButton myRunCellButton;
    private final JScrollPane myScrollPane;

    public IpnbFileEditor(Project project, VirtualFile vFile) {
        this.myDocument = FileDocumentManager.getInstance().getDocument(vFile);
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener.Before.Adapter(){

            public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor$1", "beforeFileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor$1", "beforeFileClosed"));
                }
                if (!new File(file.getPath()).exists()) {
                    return;
                }
                if (IpnbFileEditor.this.myDocument == null) {
                    return;
                }
                FileDocumentManager.getInstance().saveDocument(IpnbFileEditor.this.myDocument);
                IpnbParser.saveIpnbFile(IpnbFileEditor.this.myIpnbFilePanel);
                file.refresh(false, false);
            }
        });
        this.myFile = vFile;
        this.myName = vFile.getName();
        this.myEditorPanel = new JPanel(new BorderLayout());
        this.myEditorPanel.setBackground(IpnbEditorUtil.getBackground());
        this.myIpnbFilePanel = this.createIpnbEditorPanel(project, vFile);
        Disposer.register((Disposable)this, (Disposable)this.myIpnbFilePanel);
        JPanel controlPanel = this.createControlPanel();
        this.myEditorPanel.add((Component)controlPanel, "North");
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myIpnbFilePanel);
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.myEditorPanel.add((Component)this.myScrollPane, "Center");
        this.registerHeadingActions();
    }

    public Document getDocument() {
        return this.myDocument;
    }

    private void registerHeadingActions() {
        new IpnbHeading1CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 1")), this.myIpnbFilePanel);
        new IpnbHeading2CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 2")), this.myIpnbFilePanel);
        new IpnbHeading3CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 3")), this.myIpnbFilePanel);
        new IpnbHeading4CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 4")), this.myIpnbFilePanel);
        new IpnbHeading5CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 5")), this.myIpnbFilePanel);
        new IpnbHeading6CellAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("ctrl shift 6")), this.myIpnbFilePanel);
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setBackground(IpnbEditorUtil.getBackground());
        JPanel savePanel = new JPanel(new GridBagLayout());
        savePanel.setBackground(IpnbEditorUtil.getBackground());
        this.addSaveButton(savePanel);
        controlPanel.add(savePanel);
        JPanel addPanel = new JPanel(new GridBagLayout());
        addPanel.setBackground(IpnbEditorUtil.getBackground());
        this.addAddButton(addPanel);
        controlPanel.add(addPanel);
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.setBackground(IpnbEditorUtil.getBackground());
        this.addCutButton(editorPanel);
        this.addCopyButton(editorPanel);
        this.addPasteButton(editorPanel);
        controlPanel.add(editorPanel);
        JPanel runPanel = new JPanel(new GridBagLayout());
        runPanel.setBackground(IpnbEditorUtil.getBackground());
        this.addRunButton(runPanel);
        controlPanel.add(runPanel);
        this.myCellTypeCombo = new ComboBox((Object[])ourCellTypes);
        this.myCellTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = IpnbFileEditor.this.myCellTypeCombo.getSelectedItem();
                IpnbEditablePanel selectedCell = IpnbFileEditor.this.myIpnbFilePanel.getSelectedCell();
                if (selectedCell != null && selectedItem instanceof String) {
                    IpnbFileEditor.this.updateCellType((String)selectedItem, selectedCell);
                }
            }
        });
        IpnbEditablePanel selectedCell = this.myIpnbFilePanel.getSelectedCell();
        if (selectedCell != null) {
            this.updateCellTypeCombo(selectedCell);
        }
        controlPanel.add((Component)this.myCellTypeCombo);
        MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)JBColor.GRAY);
        controlPanel.setBorder(border);
        return controlPanel;
    }

    private void addRunButton(@NotNull JPanel controlPanel) {
        if (controlPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addRunButton"));
        }
        this.myRunCellButton = new JButton();
        this.myRunCellButton.setBackground(IpnbEditorUtil.getBackground());
        this.myRunCellButton.setPreferredSize(new Dimension(30, 30));
        this.myRunCellButton.setIcon(AllIcons.General.Run);
        this.myRunCellButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IpnbRunCellBaseAction.runCell(IpnbFileEditor.this.myIpnbFilePanel, true);
            }
        });
        this.myRunCellButton.setToolTipText("Run Cell");
        controlPanel.add(this.myRunCellButton);
    }

    private void addSaveButton(@NotNull JPanel controlPanel) {
        if (controlPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addSaveButton"));
        }
        IpnbFileEditor.addButton(controlPanel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IpnbSaveAction.saveAndCheckpoint(IpnbFileEditor.this);
            }
        }, AllIcons.Actions.Menu_saveall, "Save and Checkpoint");
    }

    private void addCutButton(@NotNull JPanel controlPanel) {
        if (controlPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addCutButton"));
        }
        IpnbFileEditor.addButton(controlPanel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IpnbCutCellAction.cutCell(IpnbFileEditor.this.myIpnbFilePanel);
            }
        }, AllIcons.Actions.Menu_cut, "Cut Cell");
    }

    private void addCopyButton(@NotNull JPanel controlPanel) {
        if (controlPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addCopyButton"));
        }
        IpnbFileEditor.addButton(controlPanel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IpnbCopyCellAction.copyCell(IpnbFileEditor.this.myIpnbFilePanel);
            }
        }, AllIcons.Actions.Copy, "Copy Cell");
    }

    private void addPasteButton(@NotNull JPanel controlPanel) {
        if (controlPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addPasteButton"));
        }
        IpnbFileEditor.addButton(controlPanel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IpnbPasteCellAction.pasteCell(IpnbFileEditor.this.myIpnbFilePanel);
            }
        }, AllIcons.Actions.Menu_paste, "Paste Cell Below");
    }

    private static void addButton(@NotNull JPanel controlPanel, @NotNull ActionListener listener, @NotNull Icon icon, @NotNull String tooltip) {
        if (controlPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addButton"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addButton"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addButton"));
        }
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addButton"));
        }
        JButton button = new JButton();
        button.setBackground(IpnbEditorUtil.getBackground());
        button.setPreferredSize(new Dimension(30, 30));
        button.setIcon(icon);
        button.addActionListener(listener);
        button.setToolTipText(tooltip);
        controlPanel.add(button);
    }

    private void addAddButton(@NotNull JPanel controlPanel) {
        if (controlPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addAddButton"));
        }
        IpnbFileEditor.addButton(controlPanel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IpnbAddCellBelowAction.addCell(IpnbFileEditor.this.myIpnbFilePanel);
            }
        }, AllIcons.General.Add, "Insert Cell Below");
    }

    public JButton getRunCellButton() {
        return this.myRunCellButton;
    }

    private void updateCellType(@NotNull String selectedItem, @NotNull IpnbEditablePanel selectedCell) {
        if (selectedItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedItem", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "updateCellType"));
        }
        if (selectedCell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedCell", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "updateCellType"));
        }
        selectedCell.updateCellSource();
        if (selectedCell instanceof IpnbHeadingPanel) {
            IpnbHeadingCell cell = (IpnbHeadingCell)((IpnbHeadingPanel)selectedCell).getCell();
            if (selectedItem.startsWith(headingCellType)) {
                char c = selectedItem.charAt(selectedItem.length() - 1);
                int level = Character.getNumericValue(c);
                if (level != cell.getLevel()) {
                    cell.setLevel(level);
                    selectedCell.updateCellView();
                }
            } else if (selectedItem.equals(markdownCellType)) {
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbHeadingPanel)selectedCell).getCell());
                IpnbMarkdownCell markdownCell = new IpnbMarkdownCell(cell.getSource());
                if (index >= 0) {
                    cells.set(index, markdownCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, markdownCell);
            } else if (selectedItem.equals(codeCellType)) {
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbHeadingPanel)selectedCell).getCell());
                IpnbCodeCell codeCell = new IpnbCodeCell("python", cell.getSource(), null, Lists.newArrayList());
                if (index >= 0) {
                    cells.set(index, codeCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, codeCell);
            }
        } else if (selectedCell instanceof IpnbMarkdownPanel) {
            IpnbMarkdownCell cell = (IpnbMarkdownCell)((IpnbMarkdownPanel)selectedCell).getCell();
            if (selectedItem.startsWith(headingCellType)) {
                char c = selectedItem.charAt(selectedItem.length() - 1);
                int level = Character.getNumericValue(c);
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbMarkdownPanel)selectedCell).getCell());
                IpnbHeadingCell headingCell = new IpnbHeadingCell(cell.getSource(), level);
                if (index >= 0) {
                    cells.set(index, headingCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, headingCell);
            } else if (selectedItem.equals(codeCellType)) {
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbMarkdownPanel)selectedCell).getCell());
                IpnbCodeCell codeCell = new IpnbCodeCell("python", cell.getSource(), null, Lists.newArrayList());
                if (index >= 0) {
                    cells.set(index, codeCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, codeCell);
            }
        } else if (selectedCell instanceof IpnbCodePanel) {
            IpnbCodeCell cell = (IpnbCodeCell)((IpnbCodePanel)selectedCell).getCell();
            if (selectedItem.startsWith(headingCellType)) {
                char c = selectedItem.charAt(selectedItem.length() - 1);
                int level = Character.getNumericValue(c);
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbCodePanel)selectedCell).getCell());
                IpnbHeadingCell headingCell = new IpnbHeadingCell(cell.getSource(), level);
                if (index >= 0) {
                    cells.set(index, headingCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, headingCell);
            } else if (selectedItem.equals(markdownCellType)) {
                List<IpnbCell> cells = this.myIpnbFilePanel.getIpnbFile().getCells();
                int index = cells.indexOf(((IpnbCodePanel)selectedCell).getCell());
                IpnbMarkdownCell markdownCell = new IpnbMarkdownCell(cell.getSource());
                if (index >= 0) {
                    cells.set(index, markdownCell);
                }
                this.myIpnbFilePanel.replaceComponent(selectedCell, markdownCell);
            }
        }
    }

    @NotNull
    private IpnbFilePanel createIpnbEditorPanel(Project project, VirtualFile vFile) {
        IpnbFilePanel ipnbFilePanel = new IpnbFilePanel(project, this, vFile, new CellSelectionListener(){

            @Override
            public void selectionChanged(@NotNull IpnbPanel ipnbPanel) {
                if (ipnbPanel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipnbPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor$9", "selectionChanged"));
                }
                if (IpnbFileEditor.this.myCellTypeCombo == null) {
                    return;
                }
                IpnbFileEditor.this.updateCellTypeCombo(ipnbPanel);
                IpnbFileEditor.this.updateScrollPosition(ipnbPanel);
            }
        });
        if (ipnbFilePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "createIpnbEditorPanel"));
        }
        return ipnbFilePanel;
    }

    public void updateScrollPosition(@NotNull IpnbPanel ipnbPanel) {
        if (ipnbPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipnbPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "updateScrollPosition"));
        }
        Rectangle rect = this.myIpnbFilePanel.getVisibleRect();
        Rectangle cellBounds = ipnbPanel.getBounds();
        if (cellBounds.getY() <= rect.getY()) {
            this.myScrollPane.getVerticalScrollBar().setValue(cellBounds.y);
        }
        if (cellBounds.getY() + cellBounds.getHeight() > rect.getY() + rect.getHeight()) {
            this.myScrollPane.getVerticalScrollBar().setValue(cellBounds.y - rect.height + cellBounds.height);
        }
    }

    private void updateCellTypeCombo(@NotNull IpnbPanel ipnbPanel) {
        if (ipnbPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipnbPanel", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "updateCellTypeCombo"));
        }
        if (ipnbPanel instanceof IpnbHeadingPanel) {
            IpnbHeadingCell cell = (IpnbHeadingCell)((IpnbHeadingPanel)ipnbPanel).getCell();
            int level = cell.getLevel();
            this.myCellTypeCombo.setSelectedItem((Object)(headingCellType + level));
        } else if (ipnbPanel instanceof IpnbMarkdownPanel) {
            this.myCellTypeCombo.setSelectedItem((Object)markdownCellType);
        } else if (ipnbPanel instanceof IpnbCodePanel) {
            this.myCellTypeCombo.setSelectedItem((Object)codeCellType);
        }
    }

    public IpnbFilePanel getIpnbFilePanel() {
        return this.myIpnbFilePanel;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myEditorPanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "getComponent"));
        }
        return jComponent;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditorPanel;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "getName"));
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "getState"));
        }
        int index = this.getIpnbFilePanel().getSelectedIndex();
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
        long modificationStamp = document != null ? document.getModificationStamp() : this.myFile.getModificationStamp();
        IpnbEditorState ipnbEditorState = new IpnbEditorState(modificationStamp, index);
        if (ipnbEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "getState"));
        }
        return ipnbEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "setState"));
        }
        int index = ((IpnbEditorState)state).getSelectedIndex();
        this.myIpnbFilePanel.setInitialPosition(index);
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/ipnb/editor/IpnbFileEditor", "removePropertyChangeListener"));
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public static abstract class CellSelectionListener {
        public abstract void selectionChanged(@NotNull IpnbPanel var1);
    }
}

