/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.IpnbFileType;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorState;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;

public class IpnbEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String SELECTED_CELL = "selected";
    @NonNls
    private static final String ID = "id";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "accept"));
        }
        return file.getFileType() == IpnbFileType.INSTANCE;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "createEditor"));
        }
        IpnbFileEditor ipnbFileEditor = new IpnbFileEditor(project, file);
        if (ipnbFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "createEditor"));
        }
        return ipnbFileEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "disposeEditor"));
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "readState"));
        }
        IpnbEditorState state = new IpnbEditorState(-1L, 0);
        Element child = sourceElement.getChild(SELECTED_CELL);
        state.setSelectedIndex(child == null ? 0 : Integer.parseInt(child.getAttributeValue(ID)));
        IpnbEditorState ipnbEditorState = state;
        if (ipnbEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "readState"));
        }
        return ipnbEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "writeState"));
        }
        IpnbEditorState editorState = (IpnbEditorState)state;
        int id = editorState.getSelectedIndex();
        Element element = new Element(SELECTED_CELL);
        element.setAttribute(ID, String.valueOf(id));
        targetElement.addContent(element);
    }

    @NotNull
    public String getEditorTypeId() {
        if ("ipnb-editor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "getEditorTypeId"));
        }
        return "ipnb-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/editor/IpnbEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

