/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.configuration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.Alarm;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.configuration.IpnbSettings;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodePanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;
import org.jetbrains.plugins.ipnb.protocol.IpnbConnection;
import org.jetbrains.plugins.ipnb.protocol.IpnbConnectionListenerBase;

public final class IpnbConnectionManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(IpnbConnectionManager.class);
    private final Project myProject;
    private Map<String, IpnbConnection> myKernels = new HashMap<String, IpnbConnection>();
    private Map<String, IpnbCodePanel> myUpdateMap = new HashMap<String, IpnbCodePanel>();
    private KillableColoredProcessHandler myProcessHandler;

    public IpnbConnectionManager(Project project) {
        this.myProject = project;
    }

    public static IpnbConnectionManager getInstance(Project project) {
        return (IpnbConnectionManager)project.getComponent(IpnbConnectionManager.class);
    }

    public void executeCell(final @NotNull IpnbCodePanel codePanel) {
        if (codePanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codePanel", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "executeCell"));
        }
        final IpnbFileEditor fileEditor = codePanel.getFileEditor();
        VirtualFile virtualFile = fileEditor.getVirtualFile();
        final String path = virtualFile.getPath();
        if (!this.myKernels.containsKey(path)) {
            String url = IpnbSettings.getInstance(this.myProject).getURL();
            if (StringUtil.isEmptyOrSpaces((String)url)) {
                IpnbConnectionManager.showWarning(fileEditor, "Please, specify IPython Notebook URL in <a href=\"\">Settings->Tools->IPython Notebook</a>", new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        ShowSettingsUtil.getInstance().showSettingsDialog(IpnbConnectionManager.this.myProject, "IPython Notebook");
                    }
                });
                return;
            }
            if (this.startConnection(codePanel, path, url, false)) {
                return;
            }
            if ((url = IpnbConnectionManager.showDialogUrl(url)) == null) {
                return;
            }
            IpnbSettings.getInstance(this.myProject).setURL(url);
            boolean connectionStarted = this.startConnection(codePanel, path, url, false);
            if (!connectionStarted) {
                final String finalUrl = url;
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        boolean serverStarted = IpnbConnectionManager.this.startIpythonServer(finalUrl, fileEditor);
                        if (!serverStarted) {
                            return;
                        }
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                new Alarm(Alarm.ThreadToUse.SWING_THREAD).addRequest(new Runnable(){

                                    @Override
                                    public void run() {
                                        Notification notification = new Notification("IPythonNotebook", "", "<html>IPython notebook started at <a href=\"" + finalUrl + "\">" + finalUrl + "</a></html>", NotificationType.INFORMATION, NotificationListener.URL_OPENING_LISTENER);
                                        notification.notify(IpnbConnectionManager.this.myProject);
                                        IpnbConnectionManager.this.startConnection(codePanel, path, finalUrl, true);
                                    }
                                }, 3000);
                            }
                        });
                    }
                });
            }
        } else {
            IpnbConnection connection = this.myKernels.get(path);
            if (connection != null) {
                String messageId = connection.execute(((IpnbCodeCell)codePanel.getCell()).getSourceAsString());
                this.myUpdateMap.put(messageId, codePanel);
            }
        }
    }

    private static String showDialogUrl(@NotNull String initialUrl) {
        if (initialUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialUrl", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "showDialogUrl"));
        }
        String url = Messages.showInputDialog((String)"IPython Notebook URL:", (String)"Start IPython Notebook", null, (String)initialUrl, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                try {
                    new URL(inputString);
                }
                catch (MalformedURLException e) {
                    return false;
                }
                return !inputString.isEmpty();
            }

            public boolean canClose(String inputString) {
                return true;
            }
        });
        return url == null ? null : StringUtil.trimEnd((String)url, (String)"/");
    }

    private boolean startConnection(final @NotNull IpnbCodePanel codePanel, @NotNull String path, @NotNull String url, boolean showNotification) {
        if (codePanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codePanel", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "startConnection"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "startConnection"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "startConnection"));
        }
        try {
            IpnbConnection connection = new IpnbConnection(new URI(url), new IpnbConnectionListenerBase(){

                @Override
                public void onOpen(@NotNull IpnbConnection connection) {
                    if (connection == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager$4", "onOpen"));
                    }
                    String messageId = connection.execute(((IpnbCodeCell)codePanel.getCell()).getSourceAsString());
                    IpnbConnectionManager.this.myUpdateMap.put(messageId, codePanel);
                }

                @Override
                public void onOutput(@NotNull IpnbConnection connection, @NotNull String parentMessageId, @NotNull List<IpnbOutputCell> outputs, @Nullable Integer execCount) {
                    if (connection == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager$4", "onOutput"));
                    }
                    if (parentMessageId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentMessageId", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager$4", "onOutput"));
                    }
                    if (outputs == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputs", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager$4", "onOutput"));
                    }
                    if (!IpnbConnectionManager.this.myUpdateMap.containsKey(parentMessageId)) {
                        return;
                    }
                    IpnbCodePanel cell = (IpnbCodePanel)IpnbConnectionManager.this.myUpdateMap.remove(parentMessageId);
                    ((IpnbCodeCell)cell.getCell()).setPromptNumber(execCount);
                    cell.updatePanel(outputs);
                }
            });
            this.myKernels.put(path, connection);
        }
        catch (URISyntaxException e) {
            if (showNotification) {
                IpnbConnectionManager.showWarning(codePanel.getFileEditor(), "Please, check IPython Notebook URL in <a href=\"\">Settings->Tools->IPython Notebook</a>", new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        ShowSettingsUtil.getInstance().showSettingsDialog(IpnbConnectionManager.this.myProject, "IPython Notebook");
                    }
                });
            }
            LOG.warn("IPython Notebook URI Syntax Error: " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            if (showNotification) {
                IpnbConnectionManager.showWarning(codePanel.getFileEditor(), "IPython Notebook connection refused");
            }
            LOG.warn("IPython Notebook connection refused: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static void showWarning(@NotNull IpnbFileEditor fileEditor, @NotNull String message, @Nullable HyperlinkAdapter listener) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "showWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "showWarning"));
        }
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, null, MessageType.WARNING.getPopupBackground(), (HyperlinkListener)listener);
        Balloon balloon = balloonBuilder.createBalloon();
        balloon.showInCenterOf((JComponent)fileEditor.getRunCellButton());
    }

    private static void showWarning(@NotNull IpnbFileEditor fileEditor, @NotNull String message) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "showWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "showWarning"));
        }
        IpnbConnectionManager.showWarning(fileEditor, message, null);
    }

    private boolean startIpythonServer(@NotNull String url, @NotNull IpnbFileEditor fileEditor) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "startIpythonServer"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "startIpythonServer"));
        }
        Module module = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getModuleForFile(fileEditor.getVirtualFile());
        if (module == null) {
            return false;
        }
        Sdk sdk = PythonSdkType.findPythonSdk((Module)module);
        if (sdk == null) {
            IpnbConnectionManager.showWarning(fileEditor, "Please check Python Interpreter in Settings->Python Interpreter");
            return false;
        }
        try {
            PyPackage ipythonPackage = PyPackageManager.getInstance((Sdk)sdk).findPackage("ipython", false);
            if (ipythonPackage == null) {
                IpnbConnectionManager.showWarning(fileEditor, "Add IPython to the interpreter of the current project.");
                return false;
            }
        }
        catch (ExecutionException ignored) {
            // empty catch block
        }
        ImmutableMap env = ImmutableMap.of((Object)"PYCHARM_EP_DIST", (Object)"ipython", (Object)"PYCHARM_EP_NAME", (Object)"ipython");
        try {
            Pair<String, String> hostPort = IpnbConnectionManager.getHostPortFromUrl(url);
            String ipython = PythonHelpersLocator.getHelperPath((String)"pycharm/pycharm_load_entry_point.py");
            ArrayList parameters = Lists.newArrayList((Object[])new String[]{sdk.getHomePath(), ipython, "notebook", "--no-browser"});
            if (hostPort.getFirst() != null) {
                parameters.add("--ip");
                parameters.add(hostPort.getFirst());
            }
            if (hostPort.getSecond() != null) {
                parameters.add("--port");
                parameters.add(hostPort.getSecond());
            }
            GeneralCommandLine commandLine = new GeneralCommandLine((List)parameters).withWorkDirectory(this.myProject.getBasePath()).withEnvironment((Map)env);
            this.myProcessHandler = new KillableColoredProcessHandler(commandLine);
            return true;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @NotNull
    public static Pair<String, String> getHostPortFromUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "getHostPortFromUrl"));
        }
        String host = null;
        String port = null;
        int index = url.indexOf("://");
        if (index != -1) {
            url = url.substring(index + 3);
        }
        if ((index = url.indexOf(58)) != -1) {
            host = url.substring(0, index);
            port = url.substring(index + 1);
        }
        Pair pair = Pair.create(host, port);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "getHostPortFromUrl"));
        }
        return pair;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
        this.shutdownKernels();
    }

    private void shutdownKernels() {
        for (IpnbConnection connection : this.myKernels.values()) {
            connection.shutdown();
            try {
                connection.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myKernels.clear();
        if (this.myProcessHandler != null) {
            this.myProcessHandler.killProcess();
        }
    }

    @NotNull
    public String getComponentName() {
        if ("IpnbConnectionManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/configuration/IpnbConnectionManager", "getComponentName"));
        }
        return "IpnbConnectionManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.shutdownKernels();
    }
}

