/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.configuration;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.configuration.IpnbSettings;

public class IpnbConfigurable
implements SearchableConfigurable {
    private JPanel myMainPanel;
    private JBTextField myFieldUrl;
    @NotNull
    private final Project myProject;

    public IpnbConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ipnb/configuration/IpnbConfigurable", "<init>"));
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myFieldUrl.setText(IpnbSettings.getInstance(this.myProject).getURL());
    }

    @Nls
    public String getDisplayName() {
        return "IPython Notebook";
    }

    public String getHelpTopic() {
        return "reference-ipnb";
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        String oldUrl = IpnbSettings.getInstance(this.myProject).getURL();
        String url = StringUtil.trimEnd((String)this.myFieldUrl.getText(), (String)"/");
        return !url.equals(oldUrl);
    }

    public void apply() throws ConfigurationException {
        String url = this.myFieldUrl.getText();
        url = StringUtil.trimEnd((String)url, (String)"/");
        IpnbSettings.getInstance(this.myProject).setURL(url);
    }

    public void reset() {
    }

    public void disposeUIResources() {
    }

    @NotNull
    public String getId() {
        if ("IpnbConfigurable" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ipnb/configuration/IpnbConfigurable", "getId"));
        }
        return "IpnbConfigurable";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("IPython Notebook URL:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFieldUrl = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

