/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.MarkdownUtil;
import com.intellij.util.ui.UIUtil;
import com.petebevin.markdown.MarkdownProcessor;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.converter.Converter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbTexPackageDefinitions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.XMLStringOutputOptions;

public class IpnbUtils {
    private static final Logger LOG = Logger.getInstance(IpnbUtils.class);
    private static final MarkdownProcessor ourMarkdownProcessor = new MarkdownProcessor();
    private static final String ourImagePrefix = "http://image";
    private static final Font ourFont = new Font("Serif", 0, 16);
    private static final String ourBodyRule = "body { font-family: \"DejaVu\"; font-size: " + ourFont.getSize() + "pt;}";
    private static final String ourCodeRule = "code { font-family: \"DejaVu\"; font-size: " + ourFont.getSize() + "pt;}";
    private static final String ourAlertRule = ".alert{ background-color: #fcf8e3;color: #c09853;padding: 8px 35px 8px 14px;border: 1px solid #fbeed5;}";
    private static final String ourAlertSuccessRule = ".alert-success{ background-color: #dff0d8;\ncolor: #468847;padding: 8px 35px 8px 14px;border: 1px solid #d6e9c6;}";
    private static final String ourAlertErrorRule = ".alert-error{ background-color: #f2dede;\ncolor: #b94a48;padding: 8px 35px 8px 14px;border: 1px solid #eed3d7;}";

    public static String markdown2Html(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/ipnb/IpnbUtils", "markdown2Html"));
        }
        description = StringUtil.replace((String)description, (String)"class=\"alert alert-success\"", (String)"class=\"alert-success\"");
        description = StringUtil.replace((String)description, (String)"class=\"alert alert-error\"", (String)"class=\"alert-error\"");
        ArrayList lines = ContainerUtil.newArrayList((Object[])description.split("\n|\r|\r\n"));
        MarkdownUtil.replaceHeaders((List)lines);
        return ourMarkdownProcessor.markdown(StringUtil.join((Collection)lines, (String)"\n"));
    }

    public static JEditorPane createLatexPane(@NotNull String source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/plugins/ipnb/IpnbUtils", "createLatexPane"));
        }
        final JEditorPane editorPane = new JEditorPane();
        editorPane.setBackground(IpnbEditorUtil.getBackground());
        editorPane.setContentType(new HTMLEditorKit().getContentType());
        editorPane.setEditorKit(new HTMLEditorKit());
        HTMLDocument document = (HTMLDocument)editorPane.getDocument();
        StyleSheet sheet = document.getStyleSheet();
        sheet.addRule(ourBodyRule);
        sheet.addRule(ourCodeRule);
        sheet.addRule(ourAlertRule);
        sheet.addRule(ourAlertSuccessRule);
        sheet.addRule(ourAlertErrorRule);
        editorPane.setEditable(false);
        String html = IpnbUtils.convertToHtml(source, document);
        editorPane.setText("<html><body>" + html + "</body></html>");
        editorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Container parent = editorPane.getParent();
                MouseEvent parentEvent = SwingUtilities.convertMouseEvent(editorPane, e, parent);
                parent.dispatchEvent(parentEvent);
            }
        });
        editorPane.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        return editorPane;
    }

    private static String convertToHtml(@NotNull String source, @NotNull HTMLDocument document) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/plugins/ipnb/IpnbUtils", "convertToHtml"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/ipnb/IpnbUtils", "convertToHtml"));
        }
        StringBuilder result = new StringBuilder();
        StringBuilder markdown = new StringBuilder();
        StringBuilder formula = new StringBuilder();
        boolean inCode = false;
        int inMultiStringCode = 0;
        boolean inEnd = false;
        boolean escaped = false;
        boolean backQuoted = false;
        int imageIndex = 0;
        for (int i = 0; i != source.length(); ++i) {
            boolean doubleDollar;
            char charAt = source.charAt(i);
            if (charAt == '`') {
                boolean bl = backQuoted = !backQuoted;
                if (source.length() > i + 2 && source.charAt(i + 1) == '`' && source.charAt(i + 2) == '`') {
                    markdown.append(escaped ? "</code>" : "<code>");
                    escaped = !escaped;
                    i += 2;
                    continue;
                }
            }
            if (escaped && charAt == '\n') {
                markdown.append("<br/>");
                continue;
            }
            if (!escaped && !backQuoted) {
                if (charAt == '$' && source.length() > i + 1 && source.charAt(i + 1) != '$') {
                    boolean bl = inCode = !inCode;
                }
                if (charAt == '\\' && source.substring(i).startsWith("\\begin")) {
                    ++inMultiStringCode;
                }
                if (charAt == '\\' && source.substring(i).startsWith("\\end")) {
                    inEnd = true;
                }
            }
            boolean bl = doubleDollar = charAt == '$' && (source.length() > i + 1 && source.charAt(i + 1) == '$' || i >= 1 && source.charAt(i - 1) == '$');
            if (inCode || inMultiStringCode != 0 || !backQuoted && doubleDollar) {
                if (markdown.length() != 0) {
                    result.append(markdown.toString());
                    markdown = new StringBuilder();
                }
                formula.append(charAt);
            } else {
                if (formula.length() != 0 && charAt == '$') {
                    formula.append(charAt);
                } else {
                    markdown.append(charAt);
                }
                if (formula.length() != 0) {
                    IpnbUtils.addFormula(formula.toString(), document, imageIndex, result);
                    ++imageIndex;
                    formula = new StringBuilder();
                }
            }
            if (!inEnd || charAt != '}') continue;
            --inMultiStringCode;
            inEnd = false;
        }
        if (formula.length() != 0) {
            IpnbUtils.addFormula(formula.toString(), document, imageIndex, result);
        }
        if (markdown.length() != 0) {
            result.append(markdown.toString());
        }
        return IpnbUtils.markdown2Html(result.toString());
    }

    private static void addFormula(@NotNull String formulaText, @NotNull HTMLDocument editorDocument, int imageIndex, StringBuilder result) {
        if (formulaText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formulaText", "org/jetbrains/plugins/ipnb/IpnbUtils", "addFormula"));
        }
        if (editorDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorDocument", "org/jetbrains/plugins/ipnb/IpnbUtils", "addFormula"));
        }
        SnuggleEngine engine = new SnuggleEngine();
        engine.getPackages().add(0, IpnbTexPackageDefinitions.getPackage());
        SnuggleSession session = engine.createSession();
        SnuggleInput input = new SnuggleInput(formulaText);
        try {
            session.parseInput(input);
            XMLStringOutputOptions options = new XMLStringOutputOptions();
            options.setIndenting(true);
            options.setAddingMathSourceAnnotations(false);
            String xmlString = session.buildXMLString(options);
            if (xmlString == null) {
                return;
            }
            LayoutContextImpl context = (LayoutContextImpl)LayoutContextImpl.getDefaultLayoutContext();
            context.setParameter(Parameter.MATHCOLOR, (Object)UIUtil.getTextAreaForeground());
            context.setParameter(Parameter.MATHSIZE, (Object)18);
            Document document = MathMLParserSupport.parseString((String)xmlString);
            BufferedImage image = Converter.getInstance().render((Node)document, (LayoutContext)context);
            try {
                Hashtable<URL, BufferedImage> cache = (Hashtable<URL, BufferedImage>)editorDocument.getProperty("imageCache");
                if (cache == null) {
                    cache = new Hashtable<URL, BufferedImage>();
                    editorDocument.putProperty("imageCache", cache);
                }
                URL u = new URL(ourImagePrefix + imageIndex + ".jpg");
                ((Dictionary)cache).put(u, image);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Throwable)e);
            LOG.info("formula text " + formulaText);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Throwable)e);
        }
        if (formulaText.startsWith("$$") || formulaText.startsWith("\\begin")) {
            result.append("<p style = \"text-align:center;\"><img src=\"").append(ourImagePrefix).append(imageIndex).append(".jpg\"/></p>");
        } else {
            result.append("<img src=\"").append(ourImagePrefix).append(imageIndex).append(".jpg\"/>");
        }
    }
}

