/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.ui.ConfigureCvsGlobalSettingsDialog;
import com.intellij.cvsSupport2.config.ui.CvsConfigurationsListEditor;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.ui.CvsTabbedWindowComponent;
import com.intellij.icons.AllIcons;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.errorView.ContentManagerProvider;
import com.intellij.ui.errorView.ErrorViewFactory;
import com.intellij.util.ui.ErrorTreeView;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CvsTabbedWindow
implements Disposable {
    private final Project myProject;
    private Editor myOutput = null;
    private ErrorTreeView myErrorsView;
    private boolean myIsInitialized;
    private boolean myIsDisposed;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.ui.CvsTabbedWindow");
    private ContentManager myContentManager;

    public CvsTabbedWindow(Project project) {
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public void dispose() {
        if (this.myOutput != null) {
            EditorFactory.getInstance().releaseEditor(this.myOutput);
            this.myOutput = null;
        }
        if (this.myErrorsView != null) {
            this.myErrorsView.dispose();
            this.myErrorsView = null;
        }
        LOG.assertTrue(!this.myIsDisposed);
    }

    private void initialize() {
        if (this.myIsInitialized) {
            return;
        }
        this.myIsInitialized = true;
        this.myIsDisposed = false;
        this.myContentManager = ContentFactory.SERVICE.getInstance().createContentManager(true, this.myProject);
        this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                JComponent removedComponent;
                JComponent component = event.getContent().getComponent();
                JComponent jComponent = removedComponent = component instanceof CvsTabbedWindowComponent ? ((CvsTabbedWindowComponent)component).getComponent() : component;
                if (removedComponent == CvsTabbedWindow.this.myErrorsView) {
                    CvsTabbedWindow.this.myErrorsView.dispose();
                    CvsTabbedWindow.this.myErrorsView = null;
                } else if (CvsTabbedWindow.this.myOutput != null && removedComponent == CvsTabbedWindow.this.myOutput.getComponent()) {
                    EditorFactory.getInstance().releaseEditor(CvsTabbedWindow.this.myOutput);
                    CvsTabbedWindow.this.myOutput = null;
                }
            }
        });
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.CVS, false, ToolWindowAnchor.BOTTOM, (Disposable)this, true);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(this.myContentManager.getComponent(), "", false);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowCvs);
        toolWindow.installWatcher(this.myContentManager);
    }

    public static CvsTabbedWindow getInstance(Project project) {
        return (CvsTabbedWindow)PeriodicalTasksCloser.getInstance().safeGetService(project, CvsTabbedWindow.class);
    }

    private int getComponentAt(int i, boolean select) {
        if (select) {
            this.getContentManager().setSelectedContent(this.getContentManager().getContent(i));
        }
        return i;
    }

    public int addTab(String s, JComponent component, boolean selectTab, boolean replaceContent, boolean lockable, boolean addDefaultToolbar, @Nullable ActionGroup toolbarActions, @NonNls String helpId) {
        int existing = this.getComponentNumNamed(s);
        if (existing != -1) {
            Content existingContent = this.getContentManager().getContent(existing);
            JComponent existingComponent = existingContent.getComponent();
            if (existingComponent instanceof DeactivateListener) {
                ((DeactivateListener)((Object)existingComponent)).deactivated();
            }
            if (!replaceContent) {
                this.getContentManager().setSelectedContent(existingContent);
                return existing;
            }
            if (!existingContent.isPinned()) {
                this.getContentManager().removeContent(existingContent, true);
                existingContent.release();
            }
        }
        CvsTabbedWindowComponent newComponent = new CvsTabbedWindowComponent(component, addDefaultToolbar, toolbarActions, this.getContentManager(), helpId);
        Content content = ContentFactory.SERVICE.getInstance().createContent(newComponent.getShownComponent(), s, lockable);
        newComponent.setContent(content);
        this.getContentManager().addContent(content);
        return this.getComponentAt(this.getContentManager().getContentCount() - 1, selectTab);
    }

    private int getComponentNumNamed(String s) {
        for (int i = 0; i < this.getContentManager().getContentCount(); ++i) {
            if (!s.equals(this.getContentManager().getContent(i).getDisplayName())) continue;
            return i;
        }
        return -1;
    }

    public Editor addOutput(Editor output) {
        LOG.assertTrue(this.myOutput == null);
        if (this.myOutput == null) {
            this.addTab(CvsBundle.message((String)"tab.title.cvs.output", (Object[])new Object[0]), output.getComponent(), false, false, false, true, null, "cvs.cvsOutput");
            this.myOutput = output;
        }
        return this.myOutput;
    }

    public ErrorTreeView getErrorsTreeView() {
        if (this.myErrorsView == null) {
            this.myErrorsView = ErrorViewFactory.SERVICE.getInstance().createErrorTreeView(this.myProject, null, true, new AnAction[]{(DefaultActionGroup)ActionManager.getInstance().getAction("CvsActions")}, new AnAction[]{new GlobalCvsSettingsAction(), new ReconfigureCvsRootAction()}, new ContentManagerProvider(){

                public ContentManager getParentContent() {
                    return CvsTabbedWindow.this.getContentManager();
                }
            });
            this.addTab(CvsBundle.message((String)"tab.title.errors", (Object[])new Object[0]), this.myErrorsView.getComponent(), true, false, true, false, null, "cvs.errors");
        }
        return this.myErrorsView;
    }

    public void hideErrors() {
    }

    public void ensureVisible(Project project) {
        ToolWindow toolWindow;
        if (project == null) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        if (toolWindowManager != null && (toolWindow = toolWindowManager.getToolWindow(ToolWindowId.CVS)) != null) {
            toolWindow.activate(null, false);
        }
    }

    public ContentManager getContentManager() {
        this.initialize();
        return this.myContentManager;
    }

    public Editor getOutput() {
        return this.myOutput;
    }

    private class ReconfigureCvsRootAction
    extends AnAction {
        public ReconfigureCvsRootAction() {
            super(CvsBundle.message((String)"action.name.reconfigure.cvs.root", (Object[])new Object[0]), null, AllIcons.Nodes.Cvs_roots);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Object data = ErrorTreeView.CURRENT_EXCEPTION_DATA_KEY.getData(e.getDataContext());
            e.getPresentation().setEnabled(data instanceof CvsException);
        }

        public void actionPerformed(AnActionEvent e) {
            Object data = ErrorTreeView.CURRENT_EXCEPTION_DATA_KEY.getData(e.getDataContext());
            CvsConfigurationsListEditor.reconfigureCvsRoot(((CvsException)((Object)data)).getCvsRoot(), CvsTabbedWindow.this.myProject);
        }
    }

    private static class GlobalCvsSettingsAction
    extends AnAction {
        public GlobalCvsSettingsAction() {
            super(CvsBundle.message((String)"configure.global.cvs.settings.action.name", (Object[])new Object[0]), null, AllIcons.Nodes.Cvs_global);
        }

        public void actionPerformed(AnActionEvent e) {
            new ConfigureCvsGlobalSettingsDialog(e.getProject()).show();
        }
    }

    public static interface DeactivateListener {
        public void deactivated();
    }
}

