/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.application;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorker;
import com.intellij.cvsSupport2.cvsIgnore.IgnoredFilesInfo;
import com.intellij.cvsSupport2.cvsIgnore.IgnoredFilesInfoImpl;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entries;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.IConnection;

public class CvsInfo {
    private volatile IgnoredFilesInfo myIgnoreFilter;
    private CvsConnectionSettings myConnectionSettings;
    private String myRepository;
    private String myStickyTag;
    private Entries myEntries;
    private boolean myIsLoaded = false;
    private final VirtualFile myParent;
    private static final VirtualFile DUMMY_ROOT = null;
    private boolean myStickyTagIsLoaded = false;

    public CvsInfo(VirtualFile parent) {
        this.myParent = parent;
    }

    public synchronized CvsConnectionSettings getConnectionSettings() {
        this.checkIsLoaded();
        return this.myConnectionSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIsLoaded() {
        if (this.myIsLoaded) {
            return;
        }
        try {
            this.loadCvsRoot();
            this.loadEntries();
            this.loadRepository();
            this.loadStickyTag();
            if (this.myRepository != null && this.myConnectionSettings != null && this.myConnectionSettings.REPOSITORY != null) {
                this.myRepository = CvsUtil.getRelativeRepositoryPath(this.myRepository, this.myConnectionSettings.REPOSITORY);
            }
            CvsEntriesManager.getInstance().watchForCvsAdminFiles(this.myParent);
        }
        finally {
            this.myIsLoaded = true;
        }
    }

    private void loadStickyTag() {
        this.myStickyTag = CvsUtil.loadStickyTagFrom(this.getParentFile());
    }

    private void loadRepository() {
        this.myRepository = CvsUtil.loadRepositoryFrom(this.getParentFile());
    }

    private void loadCvsRoot() {
        String cvsRoot = CvsUtil.loadRootFrom(this.getParentFile());
        try {
            this.myConnectionSettings = cvsRoot == null ? CvsInfo.getAbsentSettings() : CvsEntriesManager.getInstance().createConnectionSettingsOn(cvsRoot);
        }
        catch (Exception ex) {
            this.myConnectionSettings = CvsInfo.getAbsentSettings();
        }
    }

    public synchronized IgnoredFilesInfo getIgnoreFilter() {
        this.checkFilterIsLoaded();
        return this.myIgnoreFilter;
    }

    private void checkFilterIsLoaded() {
        if (this.myIgnoreFilter == null) {
            this.myIgnoreFilter = this.myParent == null ? IgnoredFilesInfo.IGNORE_NOTHING : (CvsEntriesManager.getInstance().fileIsIgnored(this.myParent) ? IgnoredFilesInfo.IGNORE_ALL : (!CvsUtil.fileIsUnderCvs(this.myParent) ? IgnoredFilesInfo.IGNORE_NOTHING : IgnoredFilesInfoImpl.createForFile(CvsUtil.cvsignoreFileFor(this.getParentFile()))));
        }
    }

    private Entries getCvsEntries() {
        this.checkIsLoaded();
        return this.myEntries;
    }

    private void loadEntries() {
        this.myEntries = !Comparing.equal((Object)this.myParent, (Object)DUMMY_ROOT) ? CvsInfo.createEntriesFor(this.getParentFile()) : new Entries();
    }

    public synchronized Collection<Entry> getEntries() {
        return new HashSet<Entry>(this.getCvsEntries().getEntries());
    }

    @Nullable
    private File getParentFile() {
        return this.myParent == null ? null : new File(this.myParent.getPath());
    }

    private static Entries createEntriesFor(File parent) {
        Entries entries = CvsUtil.getEntriesIn(new File(parent.getPath()));
        if (entries == null) {
            return new Entries();
        }
        return entries;
    }

    public void clearFilter() {
        this.myIgnoreFilter = null;
    }

    public synchronized boolean isLoaded() {
        return this.myIsLoaded;
    }

    public synchronized Entry setEntryAndReturnReplacedEntry(Entry entry) {
        Entry previousEntry = this.getEntryNamed(entry.getFileName());
        this.appendEntry(entry);
        return previousEntry;
    }

    private void appendEntry(Entry newEntry) {
        this.getCvsEntries().addEntry(newEntry);
    }

    public synchronized void removeEntryNamed(String fileName) {
        this.removeEntry(fileName);
    }

    private void removeEntry(String fileName) {
        this.getCvsEntries().removeEntry(fileName);
    }

    public synchronized VirtualFile getKey() {
        return this.myParent;
    }

    public synchronized Entry getEntryNamed(String name) {
        return this.getCvsEntries().getEntry(name);
    }

    public synchronized String getRepository() {
        this.checkIsLoaded();
        return this.myRepository;
    }

    public synchronized String getStickyTag() {
        this.checkStickyTagIsLoaded();
        return this.myStickyTag;
    }

    private void checkStickyTagIsLoaded() {
        if (!this.myStickyTagIsLoaded) {
            this.loadStickyTag();
            this.myStickyTagIsLoaded = true;
        }
    }

    public synchronized void cacheAll() {
        this.checkIsLoaded();
    }

    public synchronized void clearAll() {
        this.myEntries = null;
        this.myRepository = null;
        this.myStickyTagIsLoaded = false;
        this.myConnectionSettings = null;
        this.myIsLoaded = false;
    }

    public synchronized void clearStickyInformation() {
        this.myStickyTagIsLoaded = false;
    }

    public static CvsConnectionSettings getAbsentSettings() {
        return CvsConnectionSettingsHolder.ABSENT_SETTINGS;
    }

    public static CvsInfo getDummyCvsInfo() {
        return CvsInfoHolder.DUMMY;
    }

    private static class DummyCvsInfo
    extends CvsInfo {
        public DummyCvsInfo() {
            super(null);
        }

        @Override
        public CvsConnectionSettings getConnectionSettings() {
            return DummyCvsInfo.getAbsentSettings();
        }

        @Override
        public IgnoredFilesInfo getIgnoreFilter() {
            return IgnoredFilesInfoImpl.EMPTY_FILTER;
        }

        @Override
        public Collection<Entry> getEntries() {
            return new ArrayList<Entry>();
        }

        @Override
        public void clearFilter() {
        }

        @Override
        public boolean isLoaded() {
            return true;
        }

        @Override
        public Entry setEntryAndReturnReplacedEntry(Entry entry) {
            return null;
        }

        @Override
        public void removeEntryNamed(String fileName) {
        }

        @Override
        public VirtualFile getKey() {
            return null;
        }

        @Override
        public Entry getEntryNamed(String name) {
            return null;
        }
    }

    private static class MyInvalidCvsConnectionSettings
    extends CvsConnectionSettings {
        public MyInvalidCvsConnectionSettings() {
            super(CvsApplicationLevelConfiguration.createNewConfiguration(CvsApplicationLevelConfiguration.getInstance()));
        }

        @Override
        public int getDefaultPort() {
            return 0;
        }

        @Override
        public IConnection createConnection(ReadWriteStatistics statistics) {
            throw new RuntimeException(CvsBundle.message((String)"exception.text.cannot.connect.with.invalid.root", (Object[])new Object[0]));
        }

        @Override
        protected IConnection createOriginalConnection(ErrorRegistry errorRegistry, CvsRootConfiguration cvsRootConfiguration) {
            throw new RuntimeException(CvsBundle.message((String)"exception.text.cannot.connect.with.invalid.root", (Object[])new Object[0]));
        }

        public CommandException processException(CommandException t) {
            return t;
        }

        @Override
        public void setOffline(boolean offline) {
            throw new RuntimeException(CvsBundle.message((String)"exception.text.cannot.do.setoffline.with.invalid.root", (Object[])new Object[0]));
        }

        @Override
        public boolean isOffline() {
            return true;
        }

        public CvsLoginWorker getLoginWorker(final Project project) {
            return new CvsLoginWorker(){

                public boolean promptForPassword() {
                    return true;
                }

                public ThreeState silentLogin(boolean forceCheck) {
                    VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)CvsBundle.message((String)"message.error.invalid.cvs.root", (Object[])new Object[]{MyInvalidCvsConnectionSettings.this.getCvsRootAsString()}), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                    return ThreeState.NO;
                }

                public void goOffline() {
                    MyInvalidCvsConnectionSettings.this.setOffline(true);
                }
            };
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }

    private static class CvsInfoHolder {
        private static final CvsInfo DUMMY = new DummyCvsInfo();

        private CvsInfoHolder() {
        }
    }

    private static class CvsConnectionSettingsHolder {
        private static final CvsConnectionSettings ABSENT_SETTINGS = new MyInvalidCvsConnectionSettings();

        private CvsConnectionSettingsHolder() {
        }
    }
}

