/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.CvsBundle;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsInfo;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsRootParser;
import com.intellij.cvsSupport2.cvsstatuses.CvsStatusProvider;
import com.intellij.cvsSupport2.util.CvsFileUtil;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.SyncDateFormat;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entries;
import org.netbeans.lib.cvsclient.admin.EntriesHandler;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsUtil {
    private static final SyncDateFormat DATE_FORMATTER = new SyncDateFormat((DateFormat)new SimpleDateFormat(Entry.getLastModifiedDateFormatter().toPattern(), Locale.US));
    @NonNls
    public static final String CVS_IGNORE_FILE = ".cvsignore";
    @NonNls
    public static final String CVS_ROOT_FILE = "Root";
    private static final Logger LOG;
    @NonNls
    private static final String REPOSITORY = "Repository";
    @NonNls
    private static final String TAG = "Tag";
    @NonNls
    public static final String CVS = "CVS";
    @NonNls
    public static final String ENTRIES = "Entries";
    @NonNls
    private static final String CONFLICTS = "Conflicts";
    @NonNls
    private static final String BASE_REVISIONS_DIR = "BaseRevisions";
    @NonNls
    public static final String STICKY_DATE_PREFIX = "D";
    @NonNls
    private static final String TEMPLATE = "Template";
    @NonNls
    public static final String STICKY_BRANCH_TAG_PREFIX = "T";
    @NonNls
    public static final String STICKY_NON_BRANCH_TAG_PREFIX = "N";
    @NonNls
    public static final String HEAD = "HEAD";
    @NonNls
    public static final String BASE = "Base";
    @NonNls
    public static final String REVISION_PATTERN = "\\d+(\\.\\d+)*";

    public static void skip(InputStream inputStream, int length) throws IOException {
        int skipped = 0;
        while (skipped < length) {
            skipped = (int)((long)skipped + inputStream.skip(length - skipped));
        }
    }

    public static String getModuleName(VirtualFile file) {
        if (file.isDirectory()) {
            return CvsEntriesManager.getInstance().getRepositoryFor(file);
        }
        return CvsEntriesManager.getInstance().getRepositoryFor(file.getParent()) + "/" + file.getName();
    }

    public static String getModuleName(FilePath path) {
        if (path.isDirectory()) {
            return CvsEntriesManager.getInstance().getRepositoryFor(path.getVirtualFile());
        }
        return CvsEntriesManager.getInstance().getRepositoryFor(path.getVirtualFileParent()) + "/" + path.getName();
    }

    public static boolean fileIsUnderCvsMaybeWithVfs(VirtualFile vFile) {
        try {
            if (Registry.is((String)"cvs.roots.refresh.uses.vfs")) {
                if (vFile.isDirectory()) {
                    return CvsUtil.directoryIsUnderCVS(vFile);
                }
                return CvsUtil.fileIsUnderCvs(CvsUtil.getEntryFor(vFile));
            }
            return CvsUtil.fileIsUnderCvs(vFile);
        }
        catch (Exception e1) {
            return false;
        }
    }

    public static boolean fileIsUnderCvs(VirtualFile vFile) {
        return CvsUtil.fileIsUnderCvs(CvsVfsUtil.getFileFor(vFile));
    }

    public static boolean fileIsUnderCvs(File ioFile) {
        try {
            if (ioFile.isDirectory()) {
                return CvsUtil.directoryIsUnderCVS(ioFile);
            }
            return CvsUtil.fileIsUnderCvs(CvsUtil.getEntryFor(ioFile));
        }
        catch (Exception e1) {
            return false;
        }
    }

    private static boolean directoryIsUnderCVS(File directory) {
        if (!CvsUtil.getAdminDir(directory).isDirectory()) {
            return false;
        }
        if (!CvsUtil.getFileInTheAdminDir(directory, ENTRIES).isFile()) {
            return false;
        }
        if (!CvsUtil.getFileInTheAdminDir(directory, CVS_ROOT_FILE).isFile()) {
            return false;
        }
        return CvsUtil.getFileInTheAdminDir(directory, REPOSITORY).isFile();
    }

    private static boolean directoryIsUnderCVS(VirtualFile vDir) {
        VirtualFile dir = CvsUtil.getAdminDir(vDir);
        if (dir == null) {
            return false;
        }
        if (!CvsUtil.hasPlainFileInTheAdminDir(dir, ENTRIES)) {
            return false;
        }
        if (!CvsUtil.hasPlainFileInTheAdminDir(dir, CVS_ROOT_FILE)) {
            return false;
        }
        return CvsUtil.hasPlainFileInTheAdminDir(dir, REPOSITORY);
    }

    private static boolean hasPlainFileInTheAdminDir(VirtualFile dir, String filename) {
        VirtualFile child = dir.findChild(filename);
        return child != null && !child.isDirectory();
    }

    public static Entry getEntryFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cvsSupport2/CvsUtil", "getEntryFor"));
        }
        return CvsEntriesManager.getInstance().getEntryFor(file.getParent(), file.getName());
    }

    public static Entry getEntryFor(File ioFile) {
        File parentFile = ioFile.getParentFile();
        if (parentFile == null) {
            return null;
        }
        return CvsEntriesManager.getInstance().getEntryFor(CvsVfsUtil.findFileByIoFile(parentFile), ioFile.getName());
    }

    private static boolean fileIsUnderCvs(Entry entry) {
        return entry != null;
    }

    public static boolean filesAreUnderCvs(File[] selectedFiles) {
        return CvsUtil.allSatisfy(selectedFiles, CvsUtil.fileIsUnderCvsCondition());
    }

    public static boolean filesArentUnderCvs(File[] selectedFiles) {
        return !CvsUtil.anySatisfy(selectedFiles, CvsUtil.fileIsUnderCvsCondition());
    }

    private static FileCondition fileIsUnderCvsCondition() {
        return new FileCondition(){

            @Override
            public boolean verify(File file) {
                return CvsUtil.fileIsUnderCvs(file);
            }
        };
    }

    private static boolean allSatisfy(File[] files, FileCondition condition) {
        for (File file : files) {
            if (condition.verify(file)) continue;
            return false;
        }
        return true;
    }

    private static boolean anySatisfy(File[] files, FileCondition condition) {
        return !CvsUtil.allSatisfy(files, new ReverseFileCondition(condition));
    }

    public static boolean filesHaveParentUnderCvs(File[] files) {
        return CvsUtil.allSatisfy(files, new FileCondition(){

            @Override
            public boolean verify(File file) {
                return CvsUtil.fileHasParentUnderCvs(file);
            }
        });
    }

    private static boolean fileHasParentUnderCvs(File file) {
        return CvsUtil.fileIsUnderCvs(file.getParentFile());
    }

    public static boolean fileIsLocallyAdded(File file) {
        Entry entry = CvsUtil.getEntryFor(file);
        return entry != null && entry.isAddedFile();
    }

    public static boolean fileIsLocallyDeleted(File file) {
        Entry entry = CvsUtil.getEntryFor(file);
        return entry != null && entry.isRemoved();
    }

    public static boolean fileIsLocallyAdded(VirtualFile file) {
        return CvsUtil.fileIsLocallyAdded(CvsVfsUtil.getFileFor(file));
    }

    public static Entries getEntriesIn(File dir) {
        return CvsUtil.getEntriesHandlerIn(dir).getEntries();
    }

    private static EntriesHandler getEntriesHandlerIn(final File dir) {
        EntriesHandler entriesHandler = new EntriesHandler(dir);
        try {
            entriesHandler.read(CvsApplicationLevelConfiguration.getCharset());
            return entriesHandler;
        }
        catch (Exception ex) {
            final String entries = CvsUtil.loadFrom(dir, ENTRIES, true);
            if (entries != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String entriesFileRelativePath = CvsUtil.CVS + File.separatorChar + CvsUtil.ENTRIES;
                        Messages.showErrorDialog((String)CvsBundle.message((String)"message.error.invalid.entries", (Object[])new Object[]{entriesFileRelativePath, dir.getAbsolutePath(), entries}), (String)CvsBundle.message((String)"message.error.invalid.entries.title", (Object[])new Object[0]));
                    }
                });
            }
            return entriesHandler;
        }
    }

    public static void removeEntryFor(File file) {
        File entriesFile = file.getParentFile();
        EntriesHandler handler = new EntriesHandler(entriesFile);
        String charset = CvsApplicationLevelConfiguration.getCharset();
        try {
            handler.read(charset);
        }
        catch (IOException e) {
            return;
        }
        Entries entries = handler.getEntries();
        entries.removeEntry(file.getName());
        try {
            handler.write(CvsUtil.getLineSeparator(), charset);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        CvsEntriesManager.getInstance().removeEntryForFile(file.getParentFile(), file.getName());
    }

    private static String getLineSeparator() {
        return CodeStyleFacade.getInstance().getLineSeparator();
    }

    public static boolean fileIsLocallyRemoved(File file) {
        Entry entry = CvsUtil.getEntryFor(file);
        if (entry == null) {
            return false;
        }
        return entry.isRemoved();
    }

    public static boolean fileIsLocallyRemoved(VirtualFile file) {
        return CvsUtil.fileIsLocallyRemoved(CvsVfsUtil.getFileFor(file));
    }

    public static String formatDate(Date date) {
        return DATE_FORMATTER.format(date);
    }

    public static void saveEntryForFile(File file, Entry entry) throws IOException {
        EntriesHandler entriesHandler = new EntriesHandler(file.getParentFile());
        entriesHandler.read(CvsApplicationLevelConfiguration.getCharset());
        entriesHandler.getEntries().addEntry(entry);
        entriesHandler.write(CvsUtil.getLineSeparator(), CvsApplicationLevelConfiguration.getCharset());
    }

    public static String loadRepositoryFrom(File file) {
        return CvsUtil.loadFrom(file, REPOSITORY, true);
    }

    public static String loadRootFrom(File file) {
        return CvsUtil.loadFrom(file, CVS_ROOT_FILE, true);
    }

    @Nullable
    private static String loadFrom(File directory, String fileName, boolean trimContent) {
        if (directory == null) {
            return null;
        }
        File file = CvsUtil.getFileInTheAdminDir(directory, fileName);
        if (!file.isFile()) {
            return null;
        }
        try {
            String result = FileUtil.loadFile((File)file);
            if (trimContent) {
                return result.trim();
            }
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static File getFileInTheAdminDir(File file, String fileName) {
        return new File(CvsUtil.getAdminDir(file), fileName);
    }

    private static File getAdminDir(File file) {
        return new File(file, CVS);
    }

    private static VirtualFile getAdminDir(VirtualFile file) {
        VirtualFile child = file.findChild(CVS);
        return child != null && child.isDirectory() ? child : null;
    }

    @Nullable
    public static String getStickyDateForDirectory(VirtualFile parentFile) {
        File file = CvsVfsUtil.getFileFor(parentFile);
        return CvsUtil.getStickyDateForDirectory(file);
    }

    @Nullable
    public static String getStickyDateForDirectory(File file) {
        String tag = CvsUtil.loadStickyTagFrom(file);
        if (tag == null) {
            return null;
        }
        if (tag.startsWith(STICKY_DATE_PREFIX)) {
            return tag.substring(STICKY_DATE_PREFIX.length());
        }
        if (tag.startsWith(STICKY_BRANCH_TAG_PREFIX)) {
            return tag.substring(STICKY_BRANCH_TAG_PREFIX.length());
        }
        return tag;
    }

    public static String loadStickyTagFrom(File file) {
        return CvsUtil.loadFrom(file, TAG, true);
    }

    @Nullable
    public static String getStickyTagForDirectory(VirtualFile parentFile) {
        return CvsUtil.getStickyTagForDirectory(CvsVfsUtil.getFileFor(parentFile));
    }

    @Nullable
    public static String getStickyTagForDirectory(File ioFile) {
        String tag = CvsUtil.loadFrom(ioFile, TAG, true);
        if (tag == null) {
            return null;
        }
        if (tag.length() == 0) {
            return null;
        }
        if (tag.startsWith(STICKY_DATE_PREFIX)) {
            return null;
        }
        if (tag.startsWith(STICKY_BRANCH_TAG_PREFIX)) {
            return tag.substring(1);
        }
        if (tag.startsWith(STICKY_NON_BRANCH_TAG_PREFIX)) {
            return tag.substring(1);
        }
        return null;
    }

    public static void ignoreFile(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cvsSupport2/CvsUtil", "ignoreFile"));
        }
        VirtualFile directory = file.getParent();
        File cvsignoreFile = CvsUtil.cvsignoreFileFor(directory == null ? "" : directory.getPath());
        CvsFileUtil.appendLineToFile(file.getName(), cvsignoreFile);
        CvsEntriesManager.getInstance().clearCachedFiltersFor(directory);
    }

    public static File cvsignoreFileFor(String path) {
        return new File(new File(path), CVS_IGNORE_FILE);
    }

    public static File cvsignoreFileFor(File file) {
        return new File(file, CVS_IGNORE_FILE);
    }

    public static void addConflict(File file) {
        File conflictsFile = CvsUtil.getConflictsFile(file);
        try {
            Conflicts conflicts = Conflicts.readFrom(conflictsFile);
            conflicts.addConflictForFile(file.getName());
            conflicts.saveTo(conflictsFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static File getConflictsFile(File file) {
        return CvsUtil.getFileInTheAdminDir(file.getParentFile(), CONFLICTS);
    }

    public static void removeConflict(File file) {
        File conflictsFile = CvsUtil.getConflictsFile(file);
        if (!conflictsFile.exists()) {
            return;
        }
        try {
            Conflicts conflicts = Conflicts.readFrom(conflictsFile);
            conflicts.removeConflictForFile(file.getName());
            conflicts.saveTo(conflictsFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean isLocallyRemoved(File file) {
        Entry entry = CvsUtil.getEntryFor(file);
        if (entry == null) {
            return false;
        }
        return entry.isRemoved();
    }

    public static String getRevisionFor(File file) {
        Entry entry = CvsUtil.getEntryFor(file);
        if (entry == null) {
            return null;
        }
        return entry.getRevision();
    }

    public static boolean filesExistInCvs(File[] files) {
        return CvsUtil.allSatisfy(files, new FileCondition(){

            @Override
            public boolean verify(File file) {
                return CvsUtil.fileIsUnderCvs(file) && !CvsUtil.fileIsLocallyAdded(file);
            }
        });
    }

    public static boolean filesAreNotDeleted(File[] files) {
        return CvsUtil.allSatisfy(files, new FileCondition(){

            @Override
            public boolean verify(File file) {
                return CvsUtil.fileIsUnderCvs(file) && !CvsUtil.fileIsLocallyAdded(file) && !CvsUtil.fileIsLocallyDeleted(file);
            }
        });
    }

    public static void saveRevisionForMergedFile(@NotNull VirtualFile parent, @NotNull Entry previousEntry, List<String> revisions) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/cvsSupport2/CvsUtil", "saveRevisionForMergedFile"));
        }
        if (previousEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousEntry", "com/intellij/cvsSupport2/CvsUtil", "saveRevisionForMergedFile"));
        }
        File conflictsFile = CvsUtil.getConflictsFile(new File(CvsVfsUtil.getFileFor(parent), previousEntry.getFileName()));
        try {
            Conflicts conflicts = Conflicts.readFrom(conflictsFile);
            Date lastModified = previousEntry.getLastModified();
            conflicts.setRevisionAndDateForFile(previousEntry.getFileName(), previousEntry.getRevision(), revisions, lastModified == null ? new Date().getTime() : lastModified.getTime());
            conflicts.saveTo(conflictsFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static byte[] getStoredContentForFile(VirtualFile file, String originalRevision) {
        File ioFile = CvsVfsUtil.getFileFor(file);
        try {
            File storedRevisionFile = new File(ioFile.getParentFile(), ".#" + ioFile.getName() + "." + originalRevision);
            if (!storedRevisionFile.isFile()) {
                return null;
            }
            return FileUtil.loadFileBytes((File)storedRevisionFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static boolean haveCachedContent(VirtualFile file, String revision) {
        File storedRevisionFile = CvsUtil.createFromRevisionAndPath(file, revision);
        return storedRevisionFile != null && storedRevisionFile.isFile();
    }

    @Nullable
    private static File createFromRevisionAndPath(VirtualFile file, String revision) {
        File ioFile = CvsVfsUtil.getFileFor(file);
        File parent = new File(CvsUtil.getAdminDir(ioFile.getParentFile()), BASE_REVISIONS_DIR);
        if (!parent.exists() ? !parent.mkdirs() : parent.isFile()) {
            return null;
        }
        return new File(parent, ".#" + ioFile.getName() + "." + revision);
    }

    private static File getCachedContentFile(VirtualFile parent, String name, String revision) {
        File parentFile = new File(CvsUtil.getAdminDir(new File(parent.getPath())), BASE_REVISIONS_DIR);
        File storedRevisionFile = revision.startsWith("-") ? new File(parentFile, ".#" + name + '.' + revision.substring(1)) : new File(parentFile, ".#" + name + '.' + revision);
        if (!storedRevisionFile.exists() || !storedRevisionFile.isFile()) {
            return null;
        }
        return storedRevisionFile;
    }

    @Nullable
    public static byte[] getCachedStoredContent(VirtualFile parent, String name, String revision) {
        try {
            File storedRevisionFile = CvsUtil.getCachedContentFile(parent, name, revision);
            if (storedRevisionFile == null) {
                return null;
            }
            return FileUtil.loadFileBytes((File)storedRevisionFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static boolean restoreFileFromCachedContent(VirtualFile parent, String name, String revision, boolean makeReadOnly) {
        try {
            File cachedContentFile = CvsUtil.getCachedContentFile(parent, name, revision);
            if (cachedContentFile == null) {
                return false;
            }
            byte[] content = FileUtil.loadFileBytes((File)cachedContentFile);
            File file = new File(parent.getPath(), name);
            FileUtil.createIfDoesntExist((File)file);
            if (!file.canWrite() && !file.setWritable(true)) {
                return false;
            }
            FileUtil.writeToFile((File)file, (byte[])content);
            if (makeReadOnly && !file.setWritable(false)) {
                return false;
            }
            return file.setLastModified(cachedContentFile.lastModified());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public static void storeContentForRevision(VirtualFile file, String revision, byte[] bytes) {
        File storedRevisionFile = CvsUtil.createFromRevisionAndPath(file, revision);
        if (storedRevisionFile == null) {
            return;
        }
        if (storedRevisionFile.isFile()) {
            return;
        }
        try {
            FileUtil.writeToFile((File)storedRevisionFile, (byte[])bytes);
            storedRevisionFile.setLastModified(file.getTimeStamp());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        CvsUtil.deleteAllOtherRevisions(file, storedRevisionFile.getName());
    }

    private static void deleteAllOtherRevisions(VirtualFile file, final String storedFilename) {
        File ioFile = new File(file.getPath());
        final Pattern pattern = Pattern.compile("\\.#" + ioFile.getName().replace(".", "\\.") + "." + REVISION_PATTERN);
        File dir = new File(CvsUtil.getAdminDir(ioFile.getParentFile()), BASE_REVISIONS_DIR);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !storedFilename.equals(name) && pattern.matcher(name).matches();
            }
        });
        if (files != null) {
            for (File oldFile : files) {
                oldFile.delete();
            }
        }
    }

    public static byte[] getStoredContentForFile(VirtualFile file) {
        File ioFile = CvsVfsUtil.getFileFor(file);
        try {
            File storedRevisionFile = new File(ioFile.getParentFile(), ".#" + ioFile.getName() + "." + CvsUtil.getAllRevisionsForFile(file).get(0));
            if (!storedRevisionFile.isFile()) {
                return null;
            }
            return FileUtil.loadFileBytes((File)storedRevisionFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static long getUpToDateDateForFile(VirtualFile file) {
        try {
            return Conflicts.readFrom(CvsUtil.getConflictsFile(CvsVfsUtil.getFileFor(file))).getPreviousEntryTime(file.getName());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return -1L;
        }
    }

    public static String getOriginalRevisionForFile(VirtualFile file) {
        try {
            return Conflicts.readFrom(CvsUtil.getConflictsFile(CvsVfsUtil.getFileFor(file))).getOriginalRevisionFor(file.getName());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static void resolveConflict(VirtualFile vFile) {
        File file = CvsVfsUtil.getFileFor(vFile);
        CvsUtil.removeConflict(file);
        EntriesHandler handler = CvsUtil.getEntriesHandlerIn(file.getParentFile());
        Entries entries = handler.getEntries();
        Entry entry = entries.getEntry(file.getName());
        if (entry == null) {
            return;
        }
        long timeStamp = vFile.getTimeStamp();
        Date date = CvsStatusProvider.createDateDiffersTo(timeStamp);
        entry.parseConflictString(Entry.getLastModifiedDateFormatter().format(date));
        entries.addEntry(entry);
        try {
            handler.write(CvsUtil.getLineSeparator(), CvsApplicationLevelConfiguration.getCharset());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static String getTemplateFor(FilePath file) {
        return CvsUtil.loadFrom(file.isDirectory() ? file.getIOFile().getParentFile() : file.getIOFile(), TEMPLATE, false);
    }

    public static String getRepositoryFor(File file) {
        String result = CvsUtil.loadRepositoryFrom(file);
        if (result == null) {
            return null;
        }
        String root = CvsUtil.loadRootFrom(file);
        if (root != null) {
            CvsRootParser cvsRootParser = CvsRootParser.valueOf((String)root, (boolean)false);
            String serverRoot = cvsRootParser.REPOSITORY;
            if (serverRoot != null) {
                result = CvsUtil.getRelativeRepositoryPath(result, serverRoot);
            }
        }
        return result;
    }

    public static String getRelativeRepositoryPath(String repository, String serverRoot) {
        if ((repository = repository.replace(File.separatorChar, '/')).startsWith(serverRoot = serverRoot.replace(File.separatorChar, '/')) && (repository = repository.substring(serverRoot.length())).startsWith("/")) {
            repository = repository.substring(1);
        }
        if (repository.startsWith("./")) {
            repository = repository.substring(2);
        }
        return repository;
    }

    public static File getCvsLightweightFileForFile(File file) {
        return new File(CvsUtil.getRepositoryFor(file.getParentFile()), file.getName());
    }

    public static List<String> getAllRevisionsForFile(VirtualFile file) {
        try {
            return Conflicts.readFrom(CvsUtil.getConflictsFile(CvsVfsUtil.getFileFor(file))).getRevisionsFor(file.getName());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static void restoreFile(final VirtualFile file) {
        CvsEntriesManager cvsEntriesManager = CvsEntriesManager.getInstance();
        VirtualFile directory = file == null ? null : file.getParent();
        LOG.assertTrue(directory != null);
        CvsInfo cvsInfo = cvsEntriesManager.getCvsInfoFor(directory);
        Entry entry = cvsInfo.getEntryNamed(file.getName());
        LOG.assertTrue(entry != null);
        String revision = entry.getRevision();
        LOG.assertTrue(StringUtil.startsWithChar((CharSequence)revision, (char)'-'));
        String originalRevision = revision.substring(1);
        String date = Entry.formatLastModifiedDate((Date)CvsStatusProvider.createDateDiffersTo(file.getTimeStamp()));
        String kwdSubstitution = entry.getOptions() == null ? "" : entry.getOptions();
        String stickyDataString = entry.getStickyData();
        Entry newEntry = Entry.createEntryForLine((String)("/" + file.getName() + "/" + originalRevision + "/" + date + "/" + kwdSubstitution + "/" + stickyDataString));
        try {
            CvsUtil.saveEntryForFile(CvsVfsUtil.getFileFor(file), newEntry);
            cvsEntriesManager.clearCachedEntriesFor(directory);
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)CvsBundle.message((String)"message.error.restore.entry", (Object[])new Object[]{file.getPresentableUrl(), e.getLocalizedMessage()}), (String)CvsBundle.message((String)"message.error.restore.entry.title", (Object[])new Object[0]));
                }
            });
        }
    }

    public static boolean fileExistsInCvs(VirtualFile file) {
        VirtualFile child;
        if (file.isDirectory() && (child = file.findChild(CVS)) != null && child.isDirectory()) {
            return true;
        }
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(file);
        if (entry == null) {
            return false;
        }
        return !entry.isAddedFile();
    }

    public static boolean fileExistsInCvs(FilePath file) {
        if (file.isDirectory() && new File(file.getIOFile(), CVS).isDirectory()) {
            return true;
        }
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(file.getVirtualFileParent(), file.getName());
        if (entry == null) {
            return false;
        }
        return !entry.isAddedFile();
    }

    public static boolean storedVersionExists(String original, VirtualFile file) {
        File ioFile = CvsVfsUtil.getFileFor(file);
        File storedRevisionFile = new File(ioFile.getParentFile(), ".#" + ioFile.getName() + "." + original);
        return storedRevisionFile.isFile();
    }

    public static boolean isNonDateTag(String dirTag) {
        return dirTag.startsWith(STICKY_BRANCH_TAG_PREFIX) || dirTag.startsWith(STICKY_NON_BRANCH_TAG_PREFIX);
    }

    public static CvsConnectionSettings getCvsConnectionSettings(FilePath path) {
        VirtualFile virtualFile = path.getVirtualFile();
        if (virtualFile == null || !path.isDirectory()) {
            return CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(path.getVirtualFileParent());
        }
        return CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(virtualFile);
    }

    static {
        DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("GMT+0000"));
        LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.CvsUtil");
    }

    private static class Conflicts {
        private final Map<String, Conflict> myNameToConflict = new HashMap();

        private Conflicts() {
        }

        @NotNull
        public static Conflicts readFrom(File file) throws IOException {
            Conflicts result = new Conflicts();
            if (!file.exists()) {
                Conflicts conflicts = result;
                if (conflicts == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/CvsUtil$Conflicts", "readFrom"));
                }
                return conflicts;
            }
            List<String> lines = CvsFileUtil.readLinesFrom(file);
            for (String line : lines) {
                Conflict conflict = Conflict.readFrom(line);
                if (conflict == null) continue;
                result.addConflict(conflict);
            }
            Conflicts conflicts = result;
            if (conflicts == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/CvsUtil$Conflicts", "readFrom"));
            }
            return conflicts;
        }

        public void saveTo(File file) throws IOException {
            CvsFileUtil.storeLines(this.getConflictLines(), file);
        }

        private List<String> getConflictLines() {
            ArrayList<String> result = new ArrayList<String>();
            for (Conflict conflict : this.myNameToConflict.values()) {
                result.add(conflict.toString());
            }
            return result;
        }

        private void addConflict(Conflict conflict) {
            this.myNameToConflict.put(conflict.getFileName(), conflict);
        }

        public void setRevisionAndDateForFile(String fileName, String originalRevision, List<String> revisions, long time) {
            if (!this.myNameToConflict.containsKey(fileName)) {
                this.myNameToConflict.put(fileName, new Conflict(fileName, originalRevision, revisions, time));
            }
            this.myNameToConflict.get(fileName).setOriginalRevision(originalRevision);
            this.myNameToConflict.get(fileName).setRevisions(revisions);
        }

        public void addConflictForFile(String name) {
            if (!this.myNameToConflict.containsKey(name)) {
                this.myNameToConflict.put(name, new Conflict(name, "", new ArrayList(), -1L));
            }
        }

        public void removeConflictForFile(String name) {
            this.myNameToConflict.remove(name);
        }

        public List<String> getRevisionsFor(String name) {
            if (!this.myNameToConflict.containsKey(name)) {
                return new ArrayList<String>();
            }
            return this.myNameToConflict.get(name).getRevisions();
        }

        public long getPreviousEntryTime(String fileName) {
            if (!this.myNameToConflict.containsKey(fileName)) {
                return -1L;
            }
            return this.myNameToConflict.get(fileName).getPreviousEntryTime();
        }

        public String getOriginalRevisionFor(String name) {
            if (!this.myNameToConflict.containsKey(name)) {
                return "";
            }
            List<String> revisions = this.myNameToConflict.get(name).getRevisions();
            return revisions.isEmpty() ? "" : revisions.get(0);
        }
    }

    private static class Conflict {
        private final String myName;
        private final List<String> myRevisions;
        private final long myPreviousTime;
        private static final String DELIM = ";";

        private Conflict(String name, String originalRevision, List<String> revisions, long time) {
            this.myName = name;
            this.myRevisions = new ArrayList<String>();
            this.myRevisions.add(originalRevision);
            this.myRevisions.addAll(revisions);
            this.myPreviousTime = time;
        }

        private Conflict(String name, List<String> revisions, long time) {
            this.myName = name;
            this.myRevisions = new ArrayList<String>();
            this.myRevisions.addAll(revisions);
            this.myPreviousTime = time;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append(this.myName);
            result.append(DELIM);
            result.append(String.valueOf(this.myPreviousTime));
            result.append(DELIM);
            for (int i = 0; i < this.myRevisions.size(); ++i) {
                if (i > 0) {
                    result.append(DELIM);
                }
                result.append(this.myRevisions.get(i));
            }
            return result.toString();
        }

        public static Conflict readFrom(String line) {
            try {
                String[] strings = line.split(DELIM);
                if (strings.length == 0) {
                    return null;
                }
                String name = strings[0];
                long time = strings.length > 1 ? Long.parseLong(strings[1]) : -1L;
                int revisionsSize = strings.length > 2 ? strings.length - 2 : 0;
                String[] revisions = new String[revisionsSize];
                if (revisions.length > 0) {
                    System.arraycopy(strings, 2, revisions, 0, revisions.length);
                }
                return new Conflict(name, Arrays.asList(revisions), time);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public String getFileName() {
            return this.myName;
        }

        public long getPreviousEntryTime() {
            return this.myPreviousTime;
        }

        public List<String> getRevisions() {
            return new ArrayList<String>(this.myRevisions);
        }

        public void setOriginalRevision(String originalRevision) {
            if (!this.myRevisions.isEmpty()) {
                this.myRevisions.remove(0);
            }
            this.myRevisions.add(0, originalRevision);
        }

        public void setRevisions(List<String> revisions) {
            if (!this.myRevisions.isEmpty()) {
                String originalRevision = this.myRevisions.remove(0);
                this.myRevisions.clear();
                this.myRevisions.add(originalRevision);
                this.myRevisions.addAll(revisions);
            }
        }
    }

    private static class ReverseFileCondition
    implements FileCondition {
        private final FileCondition myCondition;

        public ReverseFileCondition(FileCondition condition) {
            this.myCondition = condition;
        }

        @Override
        public boolean verify(File file) {
            return !this.myCondition.verify(file);
        }
    }

    private static interface FileCondition {
        public boolean verify(File var1);
    }
}

