/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Tag(value="branch")
public class BranchInfo {
    @Attribute(value="name")
    public String name;
    @Attribute(value="repository")
    public String repository;
    @Attribute(value="original")
    public boolean original;

    public static List<BranchInfo> fromTaskInfo(VcsTaskHandler.TaskInfo taskInfo, boolean original) {
        ArrayList<BranchInfo> list = new ArrayList<BranchInfo>();
        for (Map.Entry entry : taskInfo.branches.entrySet()) {
            for (String repository : (Collection)entry.getValue()) {
                BranchInfo branchInfo = new BranchInfo();
                branchInfo.name = (String)entry.getKey();
                branchInfo.repository = repository;
                branchInfo.original = original;
                list.add(branchInfo);
            }
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BranchInfo info = (BranchInfo)o;
        if (this.original != info.original) {
            return false;
        }
        if (this.name != null ? !this.name.equals(info.name) : info.name != null) {
            return false;
        }
        return !(this.repository != null ? !this.repository.equals(info.repository) : info.repository != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.repository != null ? this.repository.hashCode() : 0);
        result = 31 * result + (this.original ? 1 : 0);
        return result;
    }
}

