/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.MultipleDomModelFactory;
import com.intellij.util.xml.model.SimpleModelFactory;
import com.intellij.util.xml.model.impl.CachedMultipleDomModelFactory;
import com.intellij.util.xml.model.impl.CachedSimpleDomModelFactory;
import com.intellij.util.xml.model.impl.DomModelFactoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDomModelFactory<S extends UserDataHolder, T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends DomModelFactoryHelper<T>
implements SimpleModelFactory<T, M>,
MultipleDomModelFactory<S, T, M> {
    private final Project myProject;
    private final SimpleModelFactory<T, M> mySimpleDomModelFactory;
    private final MultipleDomModelFactory<S, T, M> myMultipleDomModelFactory;

    protected BaseDomModelFactory(@NotNull Class<T> aClass, Project project, @NonNls String name) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xml/model/impl/BaseDomModelFactory", "<init>"));
        }
        super(aClass, DomService.getInstance().createModelMerger());
        this.myProject = project;
        this.mySimpleDomModelFactory = this.createSimpleModelFactory(aClass, this.getModelMerger(), project, name);
        this.myMultipleDomModelFactory = this.createMultipleDomModelFactory(aClass, this.getModelMerger(), project, name);
    }

    protected abstract S getModelScope(XmlFile var1);

    @Nullable
    protected abstract List<M> computeAllModels(@NotNull S var1);

    protected abstract M createCombinedModel(@NotNull Set<XmlFile> var1, @NotNull DomFileElement<T> var2, M var3, S var4);

    @Nullable
    public M getModel(@NotNull C context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/util/xml/model/impl/BaseDomModelFactory", "getModel"));
        }
        PsiFile psiFile = context.getContainingFile();
        if (psiFile instanceof XmlFile) {
            return this.getModelByConfigFile((XmlFile)psiFile);
        }
        return null;
    }

    @Override
    @NotNull
    public List<M> getAllModels(@NotNull S scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/xml/model/impl/BaseDomModelFactory", "getAllModels"));
        }
        List<M> list = this.myMultipleDomModelFactory.getAllModels(scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/BaseDomModelFactory", "getAllModels"));
        }
        return list;
    }

    @Override
    @Nullable
    public M getModelByConfigFile(@Nullable XmlFile psiFile) {
        return this.mySimpleDomModelFactory.getModelByConfigFile(psiFile);
    }

    @NotNull
    public Object[] computeDependencies(@Nullable M model, @Nullable S scope) {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        if (scope != null) {
            dependencies.add(ProjectRootManager.getInstance(this.getProject()));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/BaseDomModelFactory", "computeDependencies"));
        }
        return objectArray;
    }

    @Nullable
    protected M computeModel(@NotNull XmlFile psiFile, @Nullable S scope) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/util/xml/model/impl/BaseDomModelFactory", "computeModel"));
        }
        if (scope == null) {
            return null;
        }
        List<M> models = this.getAllModels(scope);
        for (DomModel model : models) {
            Set<XmlFile> configFiles = model.getConfigFiles();
            if (!configFiles.contains(psiFile)) continue;
            return (M)model;
        }
        return null;
    }

    @Override
    @Nullable
    public M getCombinedModel(@Nullable S scope) {
        return this.myMultipleDomModelFactory.getCombinedModel(scope);
    }

    @Override
    @NotNull
    public Set<XmlFile> getAllConfigFiles(@NotNull S scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/xml/model/impl/BaseDomModelFactory", "getAllConfigFiles"));
        }
        Set<XmlFile> set = this.myMultipleDomModelFactory.getAllConfigFiles(scope);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/BaseDomModelFactory", "getAllConfigFiles"));
        }
        return set;
    }

    @Override
    @Nullable
    public DomFileElement<T> createMergedModelRoot(Set<XmlFile> configFiles) {
        return this.mySimpleDomModelFactory.createMergedModelRoot(configFiles);
    }

    private CachedMultipleDomModelFactory<S, T, M, C> createMultipleDomModelFactory(Class<T> aClass, ModelMerger modelMerger, Project project, String name) {
        return new CachedMultipleDomModelFactory<S, T, M, C>(aClass, modelMerger, project, name){

            @Override
            public M getModel(@NotNull C context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/util/xml/model/impl/BaseDomModelFactory$1", "getModel"));
                }
                return BaseDomModelFactory.this.getModel(context);
            }

            @Override
            protected List<M> computeAllModels(@NotNull S scope) {
                if (scope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/xml/model/impl/BaseDomModelFactory$1", "computeAllModels"));
                }
                return BaseDomModelFactory.this.computeAllModels(scope);
            }

            @Override
            protected M createCombinedModel(Set<XmlFile> configFiles, DomFileElement<T> mergedModel, M firstModel, S scope) {
                return BaseDomModelFactory.this.createCombinedModel(configFiles, mergedModel, firstModel, scope);
            }

            @Override
            @NotNull
            public Object[] computeDependencies(@Nullable M model, @Nullable S scope) {
                Object[] objectArray = BaseDomModelFactory.this.computeDependencies(model, scope);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/BaseDomModelFactory$1", "computeDependencies"));
                }
                return objectArray;
            }

            @Override
            public S getModelScope(@NotNull XmlFile xmlFile) {
                if (xmlFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/util/xml/model/impl/BaseDomModelFactory$1", "getModelScope"));
                }
                return BaseDomModelFactory.this.getModelScope(xmlFile);
            }
        };
    }

    private CachedSimpleDomModelFactory<T, M, S> createSimpleModelFactory(Class<T> aClass, ModelMerger modelMerger, Project project, String name) {
        return new CachedSimpleDomModelFactory<T, M, S>(aClass, modelMerger, project, name){

            @Override
            protected M computeModel(@NotNull XmlFile psiFile, @Nullable S scope) {
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/util/xml/model/impl/BaseDomModelFactory$2", "computeModel"));
                }
                return BaseDomModelFactory.this.computeModel(psiFile, scope);
            }

            @Override
            @NotNull
            public Object[] computeDependencies(@Nullable M model, @Nullable S scope) {
                Object[] objectArray = BaseDomModelFactory.this.computeDependencies(model, scope);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/model/impl/BaseDomModelFactory$2", "computeDependencies"));
                }
                return objectArray;
            }

            @Override
            public S getModelScope(@NotNull XmlFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/xml/model/impl/BaseDomModelFactory$2", "getModelScope"));
                }
                return BaseDomModelFactory.this.getModelScope(file);
            }
        };
    }

    public Project getProject() {
        return this.myProject;
    }
}

