/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;

public class AnimatedIcon
extends JComponent
implements Disposable {
    private final Icon[] myIcons;
    private final Dimension myPrefSize = new Dimension();
    private int myCurrentIconIndex;
    private final Icon myPassiveIcon;
    private final Icon myEmptyPassiveIcon;
    private boolean myPaintPassive = true;
    private boolean myRunning = true;
    protected final Animator myAnimator;
    private final String myName;

    public AnimatedIcon(String name, Icon[] icons, Icon passiveIcon, int cycleLength) {
        Icon[] iconArray;
        this.myName = name;
        if (icons.length == 0) {
            Icon[] iconArray2 = new Icon[1];
            iconArray = iconArray2;
            iconArray2[0] = passiveIcon;
        } else {
            iconArray = icons;
        }
        this.myIcons = iconArray;
        this.myPassiveIcon = passiveIcon;
        for (Icon each : icons) {
            this.myPrefSize.width = Math.max(each.getIconWidth(), this.myPrefSize.width);
            this.myPrefSize.height = Math.max(each.getIconHeight(), this.myPrefSize.height);
        }
        this.myPrefSize.width = Math.max(passiveIcon.getIconWidth(), this.myPrefSize.width);
        this.myPrefSize.height = Math.max(passiveIcon.getIconHeight(), this.myPrefSize.height);
        this.myAnimator = new Animator(this.myName, icons.length, cycleLength, true){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                int len = AnimatedIcon.this.myIcons.length;
                AnimatedIcon.this.myCurrentIconIndex = frame < 0 ? 0 : (frame >= len ? len - 1 : frame);
                AnimatedIcon.this.paintImmediately(0, 0, AnimatedIcon.this.getWidth(), AnimatedIcon.this.getHeight());
            }
        };
        this.myEmptyPassiveIcon = icons.length > 0 ? EmptyIcon.create((Icon)icons[0]) : EmptyIcon.ICON_0;
        this.setOpaque(false);
    }

    public void setPaintPassiveIcon(boolean paintPassive) {
        this.myPaintPassive = paintPassive;
    }

    private boolean ensureAnimation(boolean running) {
        boolean changes;
        boolean bl = changes = this.myAnimator.isRunning() != running;
        if (running) {
            this.myAnimator.resume();
        } else {
            this.myAnimator.suspend();
        }
        return changes;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.myRunning) {
            this.ensureAnimation(true);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.ensureAnimation(false);
    }

    public void resume() {
        this.myRunning = true;
        this.ensureAnimation(true);
    }

    public void suspend() {
        this.myRunning = false;
        if (this.ensureAnimation(false)) {
            this.repaint();
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myAnimator);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.myPrefSize.width + insets.left + insets.right, this.myPrefSize.height + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Container parent = this.getParent();
            Component opaque = null;
            if (parent instanceof JComponent) {
                opaque = (JComponent)UIUtil.findNearestOpaque((JComponent)((JComponent)parent));
            }
            Color bg = opaque != null ? opaque.getBackground() : UIUtil.getPanelBackground();
            g.setColor(bg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Icon icon = this.myAnimator.isRunning() ? this.myIcons[this.myCurrentIconIndex] : this.getPassiveIcon();
        Dimension size = this.getSize();
        int x = (size.width - icon.getIconWidth()) / 2;
        int y = (size.height - icon.getIconHeight()) / 2;
        this.paintIcon(g, icon, x, y);
    }

    protected void paintIcon(Graphics g, Icon icon, int x, int y) {
        icon.paintIcon(this, g, x, y);
    }

    protected Icon getPassiveIcon() {
        return this.myPaintPassive ? this.myPassiveIcon : this.myEmptyPassiveIcon;
    }

    public boolean isRunning() {
        return this.myAnimator.isRunning();
    }

    @Override
    public String toString() {
        return this.myName + " isRunning=" + this.myRunning + " isOpaque=" + this.isOpaque() + " paintPassive=" + this.myPaintPassive;
    }
}

