/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class LazyQuery<T>
implements Query<T> {
    private final NotNullLazyValue<Query<T>> myQuery = new NotNullLazyValue<Query<T>>(){

        @NotNull
        protected Query<T> compute() {
            Query query = LazyQuery.this.computeQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LazyQuery$1", "compute"));
            }
            return query;
        }
    };

    @NotNull
    protected abstract Query<T> computeQuery();

    @Override
    @NotNull
    public Collection<T> findAll() {
        Collection collection = ((Query)this.myQuery.getValue()).findAll();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LazyQuery", "findAll"));
        }
        return collection;
    }

    @Override
    public T findFirst() {
        return (T)((Query)this.myQuery.getValue()).findFirst();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/LazyQuery", "forEach"));
        }
        return ((Query)this.myQuery.getValue()).forEach(consumer);
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/LazyQuery", "toArray"));
        }
        T[] TArray = ((Query)this.myQuery.getValue()).toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LazyQuery", "toArray"));
        }
        return TArray;
    }

    @Override
    public Iterator<T> iterator() {
        return ((Query)this.myQuery.getValue()).iterator();
    }
}

