/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.treeStructure.PatchedDefaultMutableTreeNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nullable;

public class SimpleTreeBuilder
extends AbstractTreeBuilder {
    public SimpleTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator comparator) {
        super(tree, treeModel, treeStructure, comparator);
    }

    @Override
    public boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        return ((SimpleNode)nodeDescriptor).isAlwaysShowPlus();
    }

    @Override
    public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return ((SimpleNode)nodeDescriptor).isAutoExpandNode();
    }

    @Override
    public final void updateFromRoot() {
        this.updateFromRoot(false);
    }

    public void updateFromRoot(boolean rebuild) {
        if (rebuild) {
            this.cleanUpStructureCaches();
        }
        if (EventQueue.isDispatchThread()) {
            SimpleTreeBuilder.super.queueUpdate();
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!SimpleTreeBuilder.this.isDisposed()) {
                        SimpleTreeBuilder.super.queueUpdate();
                    }
                }
            });
        }
    }

    protected final DefaultMutableTreeNode createChildNode(NodeDescriptor childDescr) {
        return new PatchedDefaultMutableTreeNode(childDescr);
    }

    private void cleanUpStructureCaches() {
        if (!(this.getTreeStructure() instanceof SimpleTreeStructure)) {
            return;
        }
        ((SimpleTreeStructure)this.getTreeStructure()).clearCaches();
    }

    public SimpleTreeBuilder initRoot() {
        this.initRootNode();
        return this;
    }
}

