/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public abstract class MoreTabsIcon {
    private int myCounter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintIcon(Component c, Graphics graphics) {
        if (this.myCounter <= 0) {
            return;
        }
        Rectangle moreRect = this.getIconRec();
        if (moreRect == null) {
            return;
        }
        int iconY = this.getIconY(moreRect);
        int iconX = this.getIconX(moreRect);
        graphics.setFont(UIUtil.getLabelFont().deriveFont((float)Math.min(8, UIUtil.getButtonFont().getSize())));
        int width = graphics.getFontMetrics().stringWidth(String.valueOf(this.myCounter));
        AllIcons.General.MoreTabs.paintIcon(c, graphics, iconX -= width / 2 + 1, iconY);
        Graphics g = graphics.create();
        try {
            GraphicsUtil.setupAntialiasing((Graphics)g, (boolean)true, (boolean)true);
            UIUtil.drawStringWithHighlighting((Graphics)g, (String)String.valueOf(this.myCounter), (int)(iconX + AllIcons.General.MoreTabs.getIconWidth() + 2), (int)(iconY + AllIcons.General.MoreTabs.getIconHeight() - 5), (Color)JBColor.BLACK, (Color)ColorUtil.withAlpha((Color)JBColor.WHITE, (double)0.9));
        }
        finally {
            g.dispose();
        }
    }

    protected int getIconX(Rectangle iconRec) {
        return iconRec.x + iconRec.width / 2 - AllIcons.General.MoreTabs.getIconWidth() / 2;
    }

    protected int getIconY(Rectangle iconRec) {
        return iconRec.y + iconRec.height / 2 - AllIcons.General.MoreTabs.getIconHeight() / 2;
    }

    @Nullable
    protected abstract Rectangle getIconRec();

    public void updateCounter(int counter) {
        this.myCounter = counter;
    }
}

