/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.switcher.QuickAccessSettings;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.ui.switcher.SwitchTarget;
import com.intellij.ui.switcher.SwitchingSession;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchManager
implements ProjectComponent,
KeyEventDispatcher,
AnActionListener {
    private final Project myProject;
    private QuickAccessSettings myQa;
    private SwitchingSession mySession;
    private boolean myWaitingForAutoInitSession;
    private final Alarm myInitSessionAlarm = new Alarm();
    private KeyEvent myAutoInitSessionEvent;
    private final Set<AnAction> mySwitchActions = new HashSet<AnAction>();
    private final Set<SwitchingSession> myFadingAway = new HashSet<SwitchingSession>();

    public SwitchManager(Project project, QuickAccessSettings quickAccess, ActionManager actionManager) {
        this.myProject = project;
        this.myQa = quickAccess;
        actionManager.addAnActionListener(this, project);
        this.mySwitchActions.add(actionManager.getAction("SwitchUp"));
        this.mySwitchActions.add(actionManager.getAction("SwitchDown"));
        this.mySwitchActions.add(actionManager.getAction("SwitchLeft"));
        this.mySwitchActions.add(actionManager.getAction("SwitchRight"));
        this.mySwitchActions.add(actionManager.getAction("SwitchApply"));
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(SwitchManager.this);
            }
        });
    }

    @Override
    public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        if (!this.mySwitchActions.contains(action)) {
            this.disposeCurrentSession(false);
        }
    }

    @Override
    public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
    }

    @Override
    public void beforeEditorTyping(char c, DataContext dataContext) {
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (!this.myQa.isEnabled()) {
            return false;
        }
        if (this.mySession != null && !this.mySession.isFinished()) {
            return false;
        }
        Component c = e.getComponent();
        Component frame = UIUtil.findUltimateParent((Component)c);
        if (frame instanceof IdeFrame && ((IdeFrame)((Object)frame)).getProject() != this.myProject) {
            return false;
        }
        if (e.getID() != 401) {
            if (this.myWaitingForAutoInitSession) {
                this.cancelWaitingForAutoInit();
            }
            return false;
        }
        if (this.myQa.getModiferCodes().contains(e.getKeyCode())) {
            if (SwitchManager.areAllModifiersPressed(e.getModifiers(), this.myQa.getModiferCodes())) {
                this.myWaitingForAutoInitSession = true;
                this.myAutoInitSessionEvent = e;
                Runnable initRunnable = new Runnable(){

                    @Override
                    public void run() {
                        IdeFocusManager.getInstance(SwitchManager.this.myProject).doWhenFocusSettlesDown(new Runnable(){

                            @Override
                            public void run() {
                                if (SwitchManager.this.myWaitingForAutoInitSession) {
                                    SwitchManager.this.tryToInitSessionFromFocus(null, false);
                                }
                            }
                        });
                    }
                };
                if (this.myFadingAway.isEmpty()) {
                    this.myInitSessionAlarm.addRequest(initRunnable, Registry.intValue((String)"actionSystem.keyGestureHoldTime"));
                } else {
                    initRunnable.run();
                }
            }
        } else if (this.myWaitingForAutoInitSession) {
            this.cancelWaitingForAutoInit();
        }
        return false;
    }

    private ActionCallback tryToInitSessionFromFocus(@Nullable SwitchTarget preselected, boolean showSpots) {
        if (this.mySession != null && !this.mySession.isFinished()) {
            return new ActionCallback.Rejected();
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        SwitchProvider provider = SwitchProvider.KEY.getData(DataManager.getInstance().getDataContext(owner));
        if (provider != null) {
            return this.initSession(new SwitchingSession(this, provider, this.myAutoInitSessionEvent, preselected, showSpots));
        }
        return new ActionCallback.Rejected();
    }

    private void cancelWaitingForAutoInit() {
        this.myWaitingForAutoInitSession = false;
        this.myInitSessionAlarm.cancelAllRequests();
    }

    public static boolean areAllModifiersPressed(@JdkConstants.InputEventMask int modifiers, Set<Integer> modifierCodes) {
        int mask = 0;
        for (Integer each : modifierCodes) {
            if (each == 16) {
                mask |= 1;
            }
            if (each == 17) {
                mask |= 2;
            }
            if (each == 157) {
                mask |= 4;
            }
            if (each != 18) continue;
            mask |= 8;
        }
        return (modifiers ^ mask) == 0;
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
        this.myQa = null;
    }

    public static SwitchManager getInstance(Project project) {
        return project != null ? project.getComponent(SwitchManager.class) : null;
    }

    public SwitchingSession getSession() {
        return this.mySession;
    }

    public ActionCallback initSession(SwitchingSession session) {
        this.cancelWaitingForAutoInit();
        this.disposeCurrentSession(false);
        this.mySession = session;
        return new ActionCallback.Done();
    }

    public void disposeCurrentSession(boolean fadeAway) {
        if (this.mySession != null) {
            this.mySession.setFadeaway(fadeAway);
            Disposer.dispose((Disposable)this.mySession);
            this.mySession = null;
        }
    }

    @Override
    public void projectOpened() {
    }

    @Override
    public void projectClosed() {
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("ViewSwitchManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/switcher/SwitchManager", "getComponentName"));
        }
        return "ViewSwitchManager";
    }

    public boolean isSessionActive() {
        return this.mySession != null && !this.mySession.isFinished();
    }

    public ActionCallback applySwitch() {
        final ActionCallback result = new ActionCallback();
        if (this.isSessionActive()) {
            final boolean showSpots = this.mySession.isShowspots();
            this.mySession.finish(false).doWhenDone(new Consumer<SwitchTarget>(){

                public void consume(final SwitchTarget switchTarget) {
                    SwitchManager.this.mySession = null;
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

                        @Override
                        public void run() {
                            SwitchManager.this.tryToInitSessionFromFocus(switchTarget, showSpots).doWhenProcessed(result.createSetDoneRunnable());
                        }
                    });
                }
            });
        } else {
            result.setDone();
        }
        return result;
    }

    public boolean canApplySwitch() {
        return this.isSessionActive() && this.mySession.isSelectionWasMoved();
    }

    public boolean isSelectionWasMoved() {
        return this.isSessionActive() && this.mySession.isSelectionWasMoved();
    }

    public void addFadingAway(SwitchingSession session) {
        this.myFadingAway.add(session);
    }

    public void removeFadingAway(SwitchingSession session) {
        this.myFadingAway.remove(session);
    }
}

