/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.util.Couple;
import com.intellij.ui.ListScrollingUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class TableScrollingUtil {
    public static void ensureIndexIsVisible(JTable table, int index, int moveDirection) {
        Rectangle cellBounds;
        int bottom;
        int top;
        int visible = TableScrollingUtil.getVisibleRowCount(table);
        int size = table.getModel().getRowCount();
        if (moveDirection == 0) {
            top = index - (visible - 1) / 2;
            bottom = top + visible - 1;
        } else if (moveDirection < 0) {
            top = index - 2;
            bottom = index;
        } else {
            top = index;
            bottom = index + 2;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = TableScrollingUtil.getCellBounds(table, top, bottom)) != null) {
            cellBounds.x = 0;
            table.scrollRectToVisible(cellBounds);
        }
    }

    public static void ensureSelectionExists(@NotNull JTable list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/TableScrollingUtil", "ensureSelectionExists"));
        }
        int size = list.getModel().getRowCount();
        if (size == 0) {
            list.clearSelection();
            return;
        }
        int selectedIndex = list.getSelectedRow();
        boolean reselect = false;
        if (selectedIndex < 0 || selectedIndex >= size) {
            selectedIndex = 0;
            reselect = true;
        }
        TableScrollingUtil.ensureIndexIsVisible(list, selectedIndex, 0);
        if (reselect) {
            list.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private static Rectangle getCellBounds(JTable table, int top, int bottom) {
        return table.getCellRect(top, 0, true).union(table.getCellRect(bottom, 0, true));
    }

    private static int getVisibleRowCount(JTable list) {
        Rectangle visibleRect = list.getVisibleRect();
        return TableScrollingUtil.getTrailingRow(list, visibleRect) - TableScrollingUtil.getLeadingRow(list, visibleRect) + 1;
    }

    public static Couple<Integer> getVisibleRows(JTable list) {
        Rectangle visibleRect = list.getVisibleRect();
        return Couple.of((Object)(TableScrollingUtil.getLeadingRow(list, visibleRect) + 1), (Object)TableScrollingUtil.getTrailingRow(list, visibleRect));
    }

    private static int getLeadingRow(JTable table, Rectangle visibleRect) {
        Point leadingPoint = table.getComponentOrientation().isLeftToRight() ? new Point(visibleRect.x, visibleRect.y) : new Point(visibleRect.x + visibleRect.width, visibleRect.y);
        return table.rowAtPoint(leadingPoint);
    }

    private static int getTrailingRow(JTable table, Rectangle visibleRect) {
        Point trailingPoint = table.getComponentOrientation().isLeftToRight() ? new Point(visibleRect.x, visibleRect.y + visibleRect.height - 1) : new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height - 1);
        return table.rowAtPoint(trailingPoint);
    }

    public static void moveDown(JTable list, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        int indexToSelect;
        int size = list.getModel().getRowCount();
        if (size == 0) {
            return;
        }
        ListSelectionModel selectionModel = list.getSelectionModel();
        int index = selectionModel.getLeadSelectionIndex();
        if (index < size - 1) {
            indexToSelect = index + 1;
        } else if (cycleScrolling && index == size - 1) {
            indexToSelect = 0;
        } else {
            return;
        }
        TableScrollingUtil.ensureIndexIsVisible(list, indexToSelect, 1);
        if (selectionModel.getSelectionMode() == 0) {
            selectionModel.setSelectionInterval(indexToSelect, indexToSelect);
        } else {
            if ((modifiers & 0x40) == 0) {
                selectionModel.removeSelectionInterval(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex());
            }
            selectionModel.addSelectionInterval(indexToSelect, indexToSelect);
        }
    }

    public static void moveUp(JTable list, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        int indexToSelect;
        int size = list.getModel().getRowCount();
        ListSelectionModel selectionModel = list.getSelectionModel();
        int index = selectionModel.getMinSelectionIndex();
        if (index > 0) {
            indexToSelect = index - 1;
        } else if (cycleScrolling && index == 0) {
            indexToSelect = size - 1;
        } else {
            return;
        }
        TableScrollingUtil.ensureIndexIsVisible(list, indexToSelect, -1);
        if (selectionModel.getSelectionMode() == 0) {
            selectionModel.setSelectionInterval(indexToSelect, indexToSelect);
        } else {
            if ((modifiers & 0x40) == 0) {
                selectionModel.removeSelectionInterval(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex());
            }
            selectionModel.addSelectionInterval(indexToSelect, indexToSelect);
        }
    }

    public static void moveHome(JTable list) {
        list.getSelectionModel().setSelectionInterval(0, 0);
        TableScrollingUtil.ensureIndexIsVisible(list, 0, 0);
    }

    public static void moveEnd(JTable list) {
        int index = list.getModel().getRowCount() - 1;
        list.getSelectionModel().setSelectionInterval(index, index);
        TableScrollingUtil.ensureIndexIsVisible(list, index, 0);
    }

    public static void movePageUp(JTable list) {
        Rectangle cellBounds;
        int bottom;
        int visible = TableScrollingUtil.getVisibleRowCount(list);
        if (visible <= 0) {
            TableScrollingUtil.moveHome(list);
            return;
        }
        int size = list.getModel().getRowCount();
        int decrement = visible - 1;
        ListSelectionModel selectionModel = list.getSelectionModel();
        int index = Math.max(selectionModel.getMinSelectionIndex() - decrement, 0);
        int visibleIndex = TableScrollingUtil.getLeadingRow(list, list.getVisibleRect());
        int top = visibleIndex - decrement;
        if (top < 0) {
            top = 0;
        }
        if ((bottom = top + visible - 1) >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = TableScrollingUtil.getCellBounds(list, top, bottom)) == null) {
            TableScrollingUtil.moveHome(list);
            return;
        }
        list.scrollRectToVisible(cellBounds);
        list.getSelectionModel().setSelectionInterval(index, index);
        TableScrollingUtil.ensureIndexIsVisible(list, index, 0);
    }

    public static void movePageDown(JTable list) {
        Rectangle cellBounds;
        int visible = TableScrollingUtil.getVisibleRowCount(list);
        if (visible <= 0) {
            TableScrollingUtil.moveEnd(list);
            return;
        }
        ListSelectionModel selectionModel = list.getSelectionModel();
        int size = list.getModel().getRowCount();
        int increment = visible - 1;
        int index = Math.min(selectionModel.getMinSelectionIndex() + increment, size - 1);
        int fisrtVisibleRow = TableScrollingUtil.getLeadingRow(list, list.getVisibleRect());
        int top = fisrtVisibleRow + increment;
        int bottom = top + visible - 1;
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = TableScrollingUtil.getCellBounds(list, top, bottom)) == null) {
            TableScrollingUtil.moveEnd(list);
            return;
        }
        list.scrollRectToVisible(cellBounds);
        list.getSelectionModel().setSelectionInterval(index, index);
        TableScrollingUtil.ensureIndexIsVisible(list, index, 0);
    }

    public static void installActions(JTable list) {
        TableScrollingUtil.installActions(list, UISettings.getInstance().CYCLE_SCROLLING);
    }

    public static void installActions(final JTable list, final boolean cycleScrolling) {
        ActionMap actionMap = list.getActionMap();
        actionMap.put("scrollUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableScrollingUtil.movePageUp(list);
            }
        });
        actionMap.put("scrollDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableScrollingUtil.movePageDown(list);
            }
        });
        actionMap.put("selectPreviousRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableScrollingUtil.moveUp(list, e.getModifiers(), cycleScrolling);
            }
        });
        actionMap.put("selectNextRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableScrollingUtil.moveDown(list, e.getModifiers(), cycleScrolling);
            }
        });
        actionMap.put("selectLastRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableScrollingUtil.moveEnd(list);
            }
        });
        actionMap.put("selectFirstRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableScrollingUtil.moveHome(list);
            }
        });
        ListScrollingUtil.maybeInstallDefaultShortcuts(list);
        new AnAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                TableScrollingUtil.moveHome(list);
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), list);
        new AnAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                TableScrollingUtil.moveEnd(list);
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), list);
        new AnAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                TableScrollingUtil.moveHome(list);
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(36, 0)), list);
        new AnAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                TableScrollingUtil.moveEnd(list);
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(35, 0)), list);
    }
}

