/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.Pass;
import com.intellij.ui.ActiveComponent;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.CenteredIcon;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;

public class InplaceButton
extends JComponent
implements ActiveComponent {
    private boolean myPainting = true;
    private boolean myActive = true;
    private BaseButtonBehavior myBehavior;
    private CenteredIcon myRegular;
    private CenteredIcon myHovered;
    private CenteredIcon myInactive;
    private int myXTransform = 0;
    private int myYTransform = 0;
    private boolean myFill;
    private boolean myHoveringEnabled;

    public InplaceButton(String tooltip, Icon icon, ActionListener listener) {
        this(new IconButton(tooltip, icon, icon), listener, null);
    }

    public InplaceButton(String tooltip, Icon icon, ActionListener listener, Pass<MouseEvent> me) {
        this(new IconButton(tooltip, icon, icon), listener, me);
    }

    public InplaceButton(IconButton source, ActionListener listener) {
        this(source, listener, null);
    }

    public InplaceButton(IconButton source, ActionListener listener, Pass<MouseEvent> me) {
        this(source, listener, me, TimedDeadzone.DEFAULT);
    }

    public InplaceButton(IconButton source, final ActionListener listener, final Pass<MouseEvent> me, TimedDeadzone.Length mouseDeadzone) {
        this.myBehavior = new BaseButtonBehavior(this, mouseDeadzone){

            @Override
            protected void execute(MouseEvent e) {
                listener.actionPerformed(new ActionEvent(e, 1001, "execute", e.getModifiers()));
            }

            @Override
            protected void repaint(Component c) {
                InplaceButton.this.doRepaintComponent(c);
            }

            @Override
            protected void pass(MouseEvent e) {
                if (me != null) {
                    me.pass((Object)e);
                }
            }
        };
        this.setIcons(source);
        this.setToolTipText(source.getTooltip());
        this.setOpaque(false);
        this.setHoveringEnabled(true);
    }

    protected void doRepaintComponent(Component c) {
        c.repaint();
    }

    public void setMouseDeadzone(TimedDeadzone.Length deadZone) {
        this.myBehavior.setMouseDeadzone(deadZone);
    }

    public void setIcons(IconButton source) {
        this.setIcons(source.getRegular(), source.getInactive(), source.getHovered());
    }

    public void setIcons(Icon regular, Icon inactive, Icon hovered) {
        if (regular == null) {
            return;
        }
        if (inactive == null) {
            inactive = regular;
        }
        if (hovered == null) {
            hovered = regular;
        }
        int width = Math.max(regular.getIconWidth(), inactive.getIconWidth());
        width = Math.max(width, hovered.getIconWidth());
        int height = Math.max(regular.getIconHeight(), inactive.getIconHeight());
        height = Math.max(height, hovered.getIconHeight());
        this.setPreferredSize(new Dimension(width, height));
        this.myRegular = new CenteredIcon(regular, width, height);
        this.myHovered = new CenteredIcon(hovered, width, height);
        this.myInactive = new CenteredIcon(inactive, width, height);
    }

    public InplaceButton setFillBg(boolean fill) {
        this.myFill = fill;
        return this;
    }

    public void setPainting(boolean active) {
        if (this.myPainting == active) {
            return;
        }
        this.myPainting = active;
        this.repaint();
    }

    public void setActive(boolean active) {
        this.myActive = active;
        this.repaint();
    }

    public void setIcon(Icon icon) {
        this.setIcons(icon, icon, icon);
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myPainting) {
            return;
        }
        if (this.myFill) {
            g.setColor(UIUtil.getBgFillColor((JComponent)this));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.translate(this.myXTransform, this.myYTransform);
        if (this.myBehavior.isHovered() && this.myHoveringEnabled) {
            if (this.myBehavior.isPressedByMouse()) {
                this.myHovered.paintIcon((Component)this, g, 1, 1);
            } else {
                this.myHovered.paintIcon((Component)this, g, 0, 0);
            }
        } else if (this.isActive()) {
            this.myRegular.paintIcon((Component)this, g, 0, 0);
        } else {
            this.myInactive.paintIcon((Component)this, g, 0, 0);
        }
        g.translate(0, 0);
    }

    public void setTransform(int x, int y) {
        this.myXTransform = x;
        this.myYTransform = y;
    }

    public void setHoveringEnabled(boolean enabled) {
        this.myHoveringEnabled = enabled;
    }

    public boolean isActive() {
        return this.myActive;
    }
}

