/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightVirtualFile
extends VirtualFile {
    private FileType myFileType;
    private CharSequence myContent = "";
    private String myName = "";
    private long myModStamp = LocalTimeCounter.currentTime();
    private boolean myIsWritable = true;
    private boolean myValid = true;
    private Language myLanguage;
    private VirtualFile myOriginalFile;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NonNls String name) {
        this(name, "");
    }

    public LightVirtualFile(@NonNls String name, CharSequence content) {
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text) {
        this(name, fileType, text, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(VirtualFile original, CharSequence text, long modificationStamp) {
        this(original.getName(), original.getFileType(), text, modificationStamp);
        this.setCharset(original.getCharset());
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text, long modificationStamp) {
        this(name, fileType, text, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text), modificationStamp);
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text, Charset charset, long modificationStamp) {
        this.myName = name;
        this.myFileType = fileType;
        this.setContent(text);
        this.myModStamp = modificationStamp;
        this.setCharset(charset);
    }

    public LightVirtualFile(String name, Language language, CharSequence text) {
        this.myName = name;
        this.setContent(text);
        this.myModStamp = LocalTimeCounter.currentTime();
        this.setLanguage(language);
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(Language language) {
        this.myLanguage = language;
        this.myFileType = language.getAssociatedFileType();
        if (this.myFileType == null) {
            this.myFileType = FileTypeRegistry.getInstance().getFileTypeByFileName(this.myName);
        }
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    private void setContent(CharSequence content) {
        this.myContent = content;
    }

    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public void setOriginalFile(VirtualFile originalFile) {
        this.myOriginalFile = originalFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        MyVirtualFileSystem myVirtualFileSystem = ourFileSystem;
        if (myVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "getFileSystem"));
        }
        return myVirtualFileSystem;
    }

    @Nullable
    public FileType getAssignedFileType() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = "/" + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "getPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "getName"));
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Override
    public VirtualFile getParent() {
        return null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.contentsToByteArray(), this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                LightVirtualFile.this.myModStamp = newModificationStamp;
                try {
                    String content = this.toString(LightVirtualFile.this.getCharset().name());
                    LightVirtualFile.this.setContent(content);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "getOutputStream"));
        }
        return outputStream;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = ((Object)this.getContent()).toString();
        byte[] byArray = charset != null ? s.getBytes(charset.name()) : s.getBytes();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public void setContent(Object requestor, CharSequence content, boolean fireEvent) {
        this.setContent(content);
        this.myModStamp = LocalTimeCounter.currentTime();
    }

    @Override
    public void setWritable(boolean b) {
        this.myIsWritable = b;
    }

    @Override
    public void rename(Object requestor, @NotNull String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/LightVirtualFile", "rename"));
        }
        this.myName = newName;
    }

    public CharSequence getContent() {
        return this.myContent;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }

    private static class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem
    implements NonPhysicalFileSystem {
        @NonNls
        private static final String PROTOCOL = "mock";

        private MyVirtualFileSystem() {
            this.startEventPropagation();
        }

        @Override
        @NotNull
        public String getProtocol() {
            if (PROTOCOL == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "getProtocol"));
            }
            return PROTOCOL;
        }

        @Override
        @Nullable
        public VirtualFile findFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "findFileByPath"));
            }
            return null;
        }

        @Override
        public void refresh(boolean asynchronous) {
        }

        @Override
        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "refreshAndFindFileByPath"));
            }
            return null;
        }

        @Override
        public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "deleteFile"));
            }
        }

        @Override
        public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "moveFile"));
            }
            if (newParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "moveFile"));
            }
        }

        @Override
        @NotNull
        public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "copyFile"));
            }
            if (newParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "copyFile"));
            }
            if (copyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "copyFile"));
            }
            throw new IOException("Cannot copy files");
        }

        @Override
        public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "renameFile"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "renameFile"));
            }
        }

        @Override
        @NotNull
        public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
            if (vDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "createChildFile"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "createChildFile"));
            }
            throw new IOException("Cannot create files");
        }

        @Override
        @NotNull
        public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
            if (vDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "createChildDirectory"));
            }
            if (dirName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem", "createChildDirectory"));
            }
            throw new IOException("Cannot create directories");
        }
    }
}

