/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubSerializationHelper {
    private final AbstractStringEnumerator myNameStorage;
    protected final TIntObjectHashMap<ObjectStubSerializer> myIdToSerializer;
    protected final TObjectIntHashMap<ObjectStubSerializer> mySerializerToId;
    private final RecentStringInterner myStringInterner;

    public StubSerializationHelper(@NotNull AbstractStringEnumerator nameStorage) {
        if (nameStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameStorage", "com/intellij/psi/stubs/StubSerializationHelper", "<init>"));
        }
        this.myIdToSerializer = new TIntObjectHashMap();
        this.mySerializerToId = new TObjectIntHashMap();
        this.myStringInterner = new RecentStringInterner();
        this.myNameStorage = nameStorage;
    }

    public void assignId(@NotNull ObjectStubSerializer serializer) throws IOException {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/psi/stubs/StubSerializationHelper", "assignId"));
        }
        int id = this.persistentId(serializer);
        ObjectStubSerializer old = (ObjectStubSerializer)this.myIdToSerializer.put(id, (Object)serializer);
        assert (old == null) : "ID: " + serializer.getExternalId() + " is not unique; Already registered serializer with this ID: " + old.getClass().getName();
        int oldId = this.mySerializerToId.put((Object)serializer, id);
        assert (oldId == 0) : "Serializer " + serializer + " is already registered; Old ID:" + oldId;
    }

    private int persistentId(@NotNull ObjectStubSerializer serializer) throws IOException {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/psi/stubs/StubSerializationHelper", "persistentId"));
        }
        return this.myNameStorage.enumerate((Object)serializer.getExternalId());
    }

    private void doSerialize(@NotNull Stub rootStub, @NotNull StubOutputStream stream) throws IOException {
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootStub", "com/intellij/psi/stubs/StubSerializationHelper", "doSerialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/stubs/StubSerializationHelper", "doSerialize"));
        }
        ObjectStubSerializer serializer = StubSerializationUtil.getSerializer(rootStub);
        DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)this.getClassId(serializer));
        serializer.serialize(rootStub, stream);
        List<? extends Stub> children = rootStub.getChildrenStubs();
        int childrenSize = children.size();
        DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)childrenSize);
        for (int i = 0; i < childrenSize; ++i) {
            this.doSerialize(children.get(i), stream);
        }
    }

    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootStub", "com/intellij/psi/stubs/StubSerializationHelper", "serialize"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/stubs/StubSerializationHelper", "serialize"));
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(true);
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, storage);
        this.doSerialize(rootStub, stubOutputStream);
        DataOutputStream resultStream = new DataOutputStream(stream);
        DataInputOutputUtil.writeINT((DataOutput)resultStream, (int)storage.myStrings.size());
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        for (String s : storage.myStrings) {
            IOUtil.writeUTFFast((byte[])buffer, (DataOutput)resultStream, (String)s);
        }
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(ObjectStubSerializer serializer) {
        int idValue = this.mySerializerToId.get((Object)serializer);
        assert (idValue != 0) : "No ID found for serializer " + LogUtil.objectAndClass((Object)serializer);
        return idValue;
    }

    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, storage);
        int numberOfStrings = DataInputOutputUtil.readINT((DataInput)inputStream);
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        storage.myStrings.ensureCapacity(numberOfStrings);
        for (int i = 0; i < numberOfStrings; ++i) {
            String s = this.myStringInterner.get(IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream));
            storage.myStrings.add(s);
        }
        Stub stub = this.deserialize(inputStream, null);
        if (stub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        return stub;
    }

    String intern(String str) {
        return this.myStringInterner.get(str);
    }

    @NotNull
    private Stub deserialize(@NotNull StubInputStream stream, @Nullable Stub parentStub) throws IOException, SerializerNotFoundException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        int id = DataInputOutputUtil.readINT((DataInput)stream);
        ObjectStubSerializer serializer = this.getClassById(id);
        if (serializer == null) {
            throw new SerializerNotFoundException("No serializer registered for stub: ID=" + id + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() : "null"));
        }
        Object stub = serializer.deserialize(stream, parentStub);
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i = 0; i < childCount; ++i) {
            this.deserialize(stream, (Stub)stub);
        }
        Object t = stub;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubSerializationHelper", "deserialize"));
        }
        return t;
    }

    private ObjectStubSerializer getClassById(int id) {
        return (ObjectStubSerializer)this.myIdToSerializer.get(id);
    }

    private static class FileLocalStringEnumerator
    implements AbstractStringEnumerator {
        private final TObjectIntHashMap<String> myEnumerates;
        private final ArrayList<String> myStrings = new ArrayList();

        FileLocalStringEnumerator(boolean forSavingStub) {
            this.myEnumerates = forSavingStub ? new TObjectIntHashMap() : null;
        }

        public int enumerate(@Nullable String value) throws IOException {
            if (value == null) {
                return 0;
            }
            assert (this.myEnumerates != null);
            int i = this.myEnumerates.get((Object)value);
            if (i == 0) {
                i = this.myStrings.size() + 1;
                this.myEnumerates.put((Object)value, i);
                this.myStrings.add(value);
            }
            return i;
        }

        public String valueOf(int idx) throws IOException {
            if (idx == 0) {
                return null;
            }
            return this.myStrings.get(idx - 1);
        }

        public void markCorrupted() {
        }

        public void close() throws IOException {
        }

        public boolean isDirty() {
            return false;
        }

        public void force() {
        }
    }
}

