/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class DefinitionsScopedSearch
extends ExtensibleQueryFactory<PsiElement, SearchParameters> {
    public static ExtensionPointName<QueryExecutor> EP_NAME;
    public static DefinitionsScopedSearch INSTANCE;

    public static Query<PsiElement> search(PsiElement definitionsOf) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(definitionsOf));
    }

    public static Query<PsiElement> search(PsiElement definitionsOf, SearchScope searchScope) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(definitionsOf, searchScope, true));
    }

    static {
        QueryExecutor[] OLD_EXECUTORS;
        EP_NAME = ExtensionPointName.create((String)"com.intellij.definitionsScopedSearch");
        INSTANCE = new DefinitionsScopedSearch();
        for (final QueryExecutor executor : OLD_EXECUTORS = (QueryExecutor[])DefinitionsSearch.EP_NAME.getExtensions()) {
            INSTANCE.registerExecutor(new QueryExecutor<PsiElement, SearchParameters>(){

                @Override
                public boolean execute(@NotNull SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
                    if (queryParameters == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/search/searches/DefinitionsScopedSearch$1", "execute"));
                    }
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/search/searches/DefinitionsScopedSearch$1", "execute"));
                    }
                    return executor.execute(queryParameters.getElement(), consumer);
                }
            });
        }
    }

    public static class SearchParameters {
        private final PsiElement myElement;
        private final SearchScope myScope;
        private final boolean myCheckDeep;

        public SearchParameters(final @NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/searches/DefinitionsScopedSearch$SearchParameters", "<init>"));
            }
            this(element, ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

                public SearchScope compute() {
                    return element.getUseScope();
                }
            }), true);
        }

        public SearchParameters(@NotNull PsiElement element, @NotNull SearchScope scope, boolean checkDeep) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/searches/DefinitionsScopedSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/DefinitionsScopedSearch$SearchParameters", "<init>"));
            }
            this.myElement = element;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/DefinitionsScopedSearch$SearchParameters", "getElement"));
            }
            return psiElement;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

                public SearchScope compute() {
                    return SearchParameters.this.myScope.intersectWith(PsiSearchHelper.SERVICE.getInstance(SearchParameters.this.myElement.getProject()).getUseScope(SearchParameters.this.myElement));
                }
            });
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/DefinitionsScopedSearch$SearchParameters", "getScope"));
            }
            return searchScope;
        }
    }
}

