/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.std;

import com.intellij.psi.codeStyle.arrangement.ArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StdArrangementExtendableSettings
extends StdArrangementSettings
implements ArrangementExtendableSettings {
    @NotNull
    private final Set<StdArrangementRuleAliasToken> myRulesAliases;
    @NotNull
    private final List<ArrangementSectionRule> myExtendedSectionRules;

    public StdArrangementExtendableSettings() {
        this.myRulesAliases = new THashSet();
        this.myExtendedSectionRules = new ArrayList<ArrangementSectionRule>();
    }

    public StdArrangementExtendableSettings(@NotNull List<ArrangementGroupingRule> groupingRules, @NotNull List<ArrangementSectionRule> sectionRules, @NotNull Collection<StdArrangementRuleAliasToken> rulesAliases) {
        if (groupingRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupingRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "<init>"));
        }
        if (sectionRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sectionRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "<init>"));
        }
        if (rulesAliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rulesAliases", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "<init>"));
        }
        super(groupingRules, sectionRules);
        this.myRulesAliases = new THashSet();
        this.myExtendedSectionRules = new ArrayList<ArrangementSectionRule>();
        this.myRulesAliases.addAll(rulesAliases);
    }

    public static StdArrangementExtendableSettings createByMatchRules(@NotNull List<ArrangementGroupingRule> groupingRules, @NotNull List<StdArrangementMatchRule> matchRules, @NotNull Collection<StdArrangementRuleAliasToken> rulesAliases) {
        if (groupingRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupingRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "createByMatchRules"));
        }
        if (matchRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchRules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "createByMatchRules"));
        }
        if (rulesAliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rulesAliases", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "createByMatchRules"));
        }
        ArrayList<ArrangementSectionRule> sectionRules = new ArrayList<ArrangementSectionRule>();
        for (StdArrangementMatchRule rule : matchRules) {
            sectionRules.add(ArrangementSectionRule.create(rule));
        }
        return new StdArrangementExtendableSettings(groupingRules, sectionRules, rulesAliases);
    }

    @Override
    public Set<StdArrangementRuleAliasToken> getRuleAliases() {
        return this.myRulesAliases;
    }

    private Set<StdArrangementRuleAliasToken> cloneTokenDefinitions() {
        THashSet definitions = new THashSet();
        for (StdArrangementRuleAliasToken definition : this.myRulesAliases) {
            definitions.add(definition.clone());
        }
        return definitions;
    }

    @Override
    public List<ArrangementSectionRule> getExtendedSectionRules() {
        if (this.myExtendedSectionRules.isEmpty()) {
            THashMap tokenIdToDefinition = new THashMap(this.myRulesAliases.size());
            for (StdArrangementRuleAliasToken alias : this.myRulesAliases) {
                String id = alias.getId();
                tokenIdToDefinition.put(id, alias);
            }
            List<ArrangementSectionRule> sections = this.getSections();
            for (ArrangementSectionRule section : sections) {
                ArrayList<StdArrangementMatchRule> extendedRules = new ArrayList<StdArrangementMatchRule>();
                for (StdArrangementMatchRule rule : section.getMatchRules()) {
                    this.appendExpandedRules(rule, extendedRules, (Map<String, StdArrangementRuleAliasToken>)tokenIdToDefinition);
                }
                this.myExtendedSectionRules.add(ArrangementSectionRule.create(section.getStartComment(), section.getEndComment(), extendedRules));
            }
        }
        return this.myExtendedSectionRules;
    }

    public void appendExpandedRules(@NotNull StdArrangementMatchRule rule, @NotNull List<StdArrangementMatchRule> rules, @NotNull Map<String, StdArrangementRuleAliasToken> tokenIdToDefinition) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "appendExpandedRules"));
        }
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "appendExpandedRules"));
        }
        if (tokenIdToDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenIdToDefinition", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "appendExpandedRules"));
        }
        List<StdArrangementMatchRule> sequence = this.getRuleSequence(rule, tokenIdToDefinition);
        if (sequence == null || sequence.isEmpty()) {
            rules.add(rule);
            return;
        }
        ArrangementCompositeMatchCondition ruleTemplate = StdArrangementExtendableSettings.removeAliasRuleToken(rule.getMatcher().getCondition());
        for (StdArrangementMatchRule matchRule : sequence) {
            ArrangementCompositeMatchCondition extendedRule = ruleTemplate.clone();
            extendedRule.addOperand(matchRule.getMatcher().getCondition());
            rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher(extendedRule)));
        }
    }

    @Nullable
    private List<StdArrangementMatchRule> getRuleSequence(@NotNull StdArrangementMatchRule rule, final @NotNull Map<String, StdArrangementRuleAliasToken> tokenIdToDefinition) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "getRuleSequence"));
        }
        if (tokenIdToDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenIdToDefinition", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "getRuleSequence"));
        }
        final List seqRule = ContainerUtil.newSmartList((Object[])new Object[0]);
        rule.getMatcher().getCondition().invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings$1", "visit"));
                }
                StdArrangementRuleAliasToken token = (StdArrangementRuleAliasToken)tokenIdToDefinition.get(condition.getType().getId());
                if (token != null && !token.getDefinitionRules().isEmpty()) {
                    seqRule.addAll(token.getDefinitionRules());
                }
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings$1", "visit"));
                }
                for (ArrangementMatchCondition operand : condition.getOperands()) {
                    if (!seqRule.isEmpty()) {
                        return;
                    }
                    operand.invite(this);
                }
            }
        });
        return seqRule;
    }

    @NotNull
    private static ArrangementCompositeMatchCondition removeAliasRuleToken(ArrangementMatchCondition original) {
        final ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
        original.invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings$2", "visit"));
                }
                if (!ArrangementUtil.isAliasedCondition(condition)) {
                    composite.addOperand(condition);
                }
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings$2", "visit"));
                }
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                }
            }
        });
        ArrangementCompositeMatchCondition arrangementCompositeMatchCondition = composite;
        if (arrangementCompositeMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "removeAliasRuleToken"));
        }
        return arrangementCompositeMatchCondition;
    }

    @Override
    public void addRule(@NotNull StdArrangementMatchRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "addRule"));
        }
        super.addRule(rule);
        this.myExtendedSectionRules.clear();
    }

    @Override
    @NotNull
    public List<? extends ArrangementMatchRule> getRulesSortedByPriority() {
        if (this.myRulesByPriority.isEmpty()) {
            for (ArrangementSectionRule rule : this.getExtendedSectionRules()) {
                this.myRulesByPriority.addAll(rule.getMatchRules());
            }
            ContainerUtil.sort((List)this.myRulesByPriority);
        }
        List list = this.myRulesByPriority;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "getRulesSortedByPriority"));
        }
        return list;
    }

    @Override
    @NotNull
    public StdArrangementExtendableSettings clone() {
        StdArrangementExtendableSettings stdArrangementExtendableSettings = new StdArrangementExtendableSettings(this.cloneGroupings(), this.cloneSectionRules(), this.cloneTokenDefinitions());
        if (stdArrangementExtendableSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/std/StdArrangementExtendableSettings", "clone"));
        }
        return stdArrangementExtendableSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementExtendableSettings settings = (StdArrangementExtendableSettings)o;
        if (!super.equals(settings)) {
            return false;
        }
        return ((Object)this.myRulesAliases).equals(settings.myRulesAliases);
    }
}

