/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.model;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArrangementCompositeMatchCondition
implements ArrangementMatchCondition {
    @NotNull
    private final Set<ArrangementMatchCondition> myOperands;

    public ArrangementCompositeMatchCondition() {
        this.myOperands = new HashSet();
    }

    public ArrangementCompositeMatchCondition(@NotNull Collection<? extends ArrangementMatchCondition> conditions) {
        if (conditions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditions", "com/intellij/psi/codeStyle/arrangement/model/ArrangementCompositeMatchCondition", "<init>"));
        }
        this.myOperands = new HashSet();
        this.myOperands.addAll(conditions);
    }

    @NotNull
    public Set<ArrangementMatchCondition> getOperands() {
        Set<ArrangementMatchCondition> set = this.myOperands;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/model/ArrangementCompositeMatchCondition", "getOperands"));
        }
        return set;
    }

    @NotNull
    public ArrangementCompositeMatchCondition addOperand(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/model/ArrangementCompositeMatchCondition", "addOperand"));
        }
        this.myOperands.add(condition);
        ArrangementCompositeMatchCondition arrangementCompositeMatchCondition = this;
        if (arrangementCompositeMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/model/ArrangementCompositeMatchCondition", "addOperand"));
        }
        return arrangementCompositeMatchCondition;
    }

    public void removeOperand(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/model/ArrangementCompositeMatchCondition", "removeOperand"));
        }
        this.myOperands.remove(condition);
    }

    @Override
    public void invite(@NotNull ArrangementMatchConditionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/codeStyle/arrangement/model/ArrangementCompositeMatchCondition", "invite"));
        }
        visitor.visit(this);
    }

    @Override
    @NotNull
    public ArrangementCompositeMatchCondition clone() {
        ArrangementCompositeMatchCondition result = new ArrangementCompositeMatchCondition();
        for (ArrangementMatchCondition operand : this.myOperands) {
            result.addOperand(operand.clone());
        }
        ArrangementCompositeMatchCondition arrangementCompositeMatchCondition = result;
        if (arrangementCompositeMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/model/ArrangementCompositeMatchCondition", "clone"));
        }
        return arrangementCompositeMatchCondition;
    }

    public int hashCode() {
        return ((Object)this.myOperands).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementCompositeMatchCondition setting = (ArrangementCompositeMatchCondition)o;
        return ((Object)this.myOperands).equals(setting.myOperands);
    }

    public String toString() {
        return String.format("(%s)", StringUtil.join(this.myOperands, (String)" and "));
    }
}

