/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StdArrangementMatchRule
extends ArrangementMatchRule
implements Cloneable,
Comparable<StdArrangementMatchRule> {
    public StdArrangementMatchRule(@NotNull StdArrangementEntryMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "<init>"));
        }
        super(matcher);
    }

    public StdArrangementMatchRule(@NotNull StdArrangementEntryMatcher matcher, @NotNull ArrangementSettingsToken orderType) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "<init>"));
        }
        if (orderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderType", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "<init>"));
        }
        super(matcher, orderType);
    }

    @Override
    @NotNull
    public StdArrangementEntryMatcher getMatcher() {
        StdArrangementEntryMatcher stdArrangementEntryMatcher = (StdArrangementEntryMatcher)super.getMatcher();
        if (stdArrangementEntryMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "getMatcher"));
        }
        return stdArrangementEntryMatcher;
    }

    public StdArrangementMatchRule clone() {
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(this.getMatcher().getCondition().clone()), this.getOrderType());
    }

    @Override
    public int compareTo(@NotNull StdArrangementMatchRule o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "compareTo"));
        }
        Map<ArrangementSettingsToken, Object> tokenValues = ArrangementUtil.extractTokens(this.getMatcher().getCondition());
        Map<ArrangementSettingsToken, Object> tokenValues1 = ArrangementUtil.extractTokens(o.getMatcher().getCondition());
        Set<ArrangementSettingsToken> tokens = tokenValues.keySet();
        Set<ArrangementSettingsToken> tokens1 = tokenValues1.keySet();
        if (tokens1.containsAll(tokens)) {
            return tokens.containsAll(tokens1) ? 0 : 1;
        }
        if (tokens.containsAll(tokens1)) {
            return -1;
        }
        String entryType = StdArrangementMatchRule.getEntryType(tokenValues);
        String entryType1 = StdArrangementMatchRule.getEntryType(tokenValues1);
        int compare = StringUtil.compare((String)entryType1, (String)entryType, (boolean)false);
        if (compare != 0 || tokens.size() == tokens1.size()) {
            return compare;
        }
        return tokens.size() < tokens1.size() ? 1 : -1;
    }

    @Nullable
    private static String getEntryType(@NotNull Map<ArrangementSettingsToken, Object> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/psi/codeStyle/arrangement/match/StdArrangementMatchRule", "getEntryType"));
        }
        for (Map.Entry<ArrangementSettingsToken, Object> token : tokens.entrySet()) {
            Object value;
            if (!StdArrangementTokenType.ENTRY_TYPE.is(token.getKey()) || (value = token.getValue()) instanceof Boolean && !((Boolean)value).booleanValue()) continue;
            return token.getKey().getId();
        }
        return null;
    }
}

