/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ByModifierArrangementEntryMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final Set<ArrangementAtomMatchCondition> myModifiers;

    public ByModifierArrangementEntryMatcher(@NotNull ArrangementAtomMatchCondition interestedModifier) {
        if (interestedModifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interestedModifier", "com/intellij/psi/codeStyle/arrangement/match/ByModifierArrangementEntryMatcher", "<init>"));
        }
        this.myModifiers = ContainerUtilRt.newHashSet();
        this.myModifiers.add(interestedModifier);
    }

    public ByModifierArrangementEntryMatcher(@NotNull Collection<ArrangementAtomMatchCondition> interestedModifiers) {
        if (interestedModifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interestedModifiers", "com/intellij/psi/codeStyle/arrangement/match/ByModifierArrangementEntryMatcher", "<init>"));
        }
        this.myModifiers = ContainerUtilRt.newHashSet();
        this.myModifiers.addAll(interestedModifiers);
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/match/ByModifierArrangementEntryMatcher", "isMatched"));
        }
        if (entry instanceof ModifierAwareArrangementEntry) {
            Set<ArrangementSettingsToken> modifiers = ((ModifierAwareArrangementEntry)entry).getModifiers();
            for (ArrangementAtomMatchCondition condition : this.myModifiers) {
                Object value = condition.getValue();
                boolean isInverted = value instanceof Boolean && (Boolean)value == false;
                if (isInverted != modifiers.contains(condition.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.myModifiers).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByModifierArrangementEntryMatcher matcher = (ByModifierArrangementEntryMatcher)o;
        return ((Object)this.myModifiers).equals(matcher.myModifiers);
    }

    public String toString() {
        return "with modifiers " + this.myModifiers;
    }
}

