/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PsiFilePattern<T extends PsiFile, Self extends PsiFilePattern<T, Self>>
extends PsiElementPattern<T, Self> {
    protected PsiFilePattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiFilePattern", "<init>"));
        }
        super(condition);
    }

    protected PsiFilePattern(Class<T> aClass) {
        super(aClass);
    }

    public Self withParentDirectoryName(final StringPattern namePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withParentDirectoryName"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiFilePattern$1", "accepts"));
                }
                PsiDirectory directory = t.getContainingDirectory();
                return directory != null && namePattern.getCondition().accepts(directory.getName(), context);
            }
        }));
    }

    public Self withOriginalFile(final ElementPattern<? extends T> filePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withOriginalFile"){

            @Override
            public boolean accepts(@NotNull T file, ProcessingContext context) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/patterns/PsiFilePattern$2", "accepts"));
                }
                return filePattern.accepts(file.getOriginalFile());
            }
        }));
    }

    public Self withVirtualFile(final ElementPattern<? extends VirtualFile> vFilePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withVirtualFile"){

            @Override
            public boolean accepts(@NotNull T file, ProcessingContext context) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/patterns/PsiFilePattern$3", "accepts"));
                }
                return vFilePattern.accepts(file.getVirtualFile(), context);
            }
        }));
    }

    public Self withFileType(final ElementPattern<? extends FileType> fileTypePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withFileType"){

            @Override
            public boolean accepts(@NotNull T file, ProcessingContext context) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/patterns/PsiFilePattern$4", "accepts"));
                }
                return fileTypePattern.accepts(file.getFileType(), context);
            }
        }));
    }

    public static class Capture<T extends PsiFile>
    extends PsiFilePattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiFilePattern$Capture", "<init>"));
            }
            super(condition);
        }
    }
}

