/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionPattern<T>
extends ObjectPattern<Collection<T>, CollectionPattern<T>> {
    private static final InitialPatternCondition CONDITION = new InitialPatternCondition<Collection>(Collection.class){

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return o instanceof Collection;
        }
    };

    protected CollectionPattern() {
        super(CONDITION);
    }

    public CollectionPattern<T> all(final ElementPattern<? extends T> pattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("all"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context) {
                if (collection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/patterns/CollectionPattern$2", "accepts"));
                }
                for (Object t : collection) {
                    if (pattern.getCondition().accepts(t, context)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public CollectionPattern<T> atLeastOne(final ElementPattern<? extends T> pattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("atLeastOne"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context) {
                if (collection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/patterns/CollectionPattern$3", "accepts"));
                }
                for (Object t : collection) {
                    if (!pattern.getCondition().accepts(t, context)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public CollectionPattern<T> filter(final ElementPattern<? extends T> elementPattern, final ElementPattern<Collection<T>> continuationPattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("filter"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context) {
                if (collection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/patterns/CollectionPattern$4", "accepts"));
                }
                ArrayList filtered = new ArrayList();
                for (Object t : collection) {
                    if (!elementPattern.getCondition().accepts(t, context)) continue;
                    filtered.add(t);
                }
                return continuationPattern.getCondition().accepts(filtered, context);
            }
        });
    }

    public CollectionPattern<T> first(final ElementPattern<? extends T> elementPattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("first"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context) {
                if (collection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/patterns/CollectionPattern$5", "accepts"));
                }
                return !collection.isEmpty() && elementPattern.getCondition().accepts(collection.iterator().next(), context);
            }
        });
    }

    public CollectionPattern<T> empty() {
        return this.size(0);
    }

    public CollectionPattern<T> notEmpty() {
        return this.atLeast(1);
    }

    public CollectionPattern<T> atLeast(final int size) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("atLeast"){

            @Override
            public boolean accepts(@NotNull Collection<T> ts, ProcessingContext context) {
                if (ts == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ts", "com/intellij/patterns/CollectionPattern$6", "accepts"));
                }
                return ts.size() >= size;
            }
        });
    }

    public CollectionPattern<T> size(final int size) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("size"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context) {
                if (collection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/patterns/CollectionPattern$7", "accepts"));
                }
                return size == collection.size();
            }
        });
    }

    public CollectionPattern<T> last(final ElementPattern elementPattern) {
        return (CollectionPattern)this.with(new PatternCondition<Collection<T>>("last"){

            @Override
            public boolean accepts(@NotNull Collection<T> collection, ProcessingContext context) {
                if (collection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/patterns/CollectionPattern$8", "accepts"));
                }
                if (collection.isEmpty()) {
                    return false;
                }
                Object last = null;
                for (Object t : collection) {
                    last = t;
                }
                return elementPattern.getCondition().accepts(last, context);
            }
        });
    }
}

