/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import java.beans.PropertyChangeListener;
import java.nio.charset.Charset;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EncodingManager
extends EncodingRegistry {
    @NonNls
    public static final String PROP_NATIVE2ASCII_SWITCH = "native2ascii";
    @NonNls
    public static final String PROP_PROPERTIES_FILES_ENCODING = "propertiesFilesEncoding";

    @NotNull
    public static EncodingManager getInstance() {
        EncodingManager encodingManager = ServiceManager.getService(EncodingManager.class);
        if (encodingManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingManager", "getInstance"));
        }
        return encodingManager;
    }

    @NotNull
    public abstract Collection<Charset> getFavorites();

    @Deprecated
    public abstract void setUseUTFGuessing(VirtualFile var1, boolean var2);

    @Override
    public abstract boolean isNative2AsciiForPropertiesFiles();

    public abstract void setNative2AsciiForPropertiesFiles(VirtualFile var1, boolean var2);

    @Nullable
    public String getDefaultCharsetName() {
        Charset charset = this.getDefaultCharset();
        return charset == null ? null : charset.displayName();
    }

    public void setDefaultCharsetName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/encoding/EncodingManager", "setDefaultCharsetName"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Nullable
    public abstract Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile var1);

    public abstract void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile var1, @Nullable Charset var2);

    public abstract void addPropertyChangeListener(@NotNull PropertyChangeListener var1);

    public abstract void addPropertyChangeListener(@NotNull PropertyChangeListener var1, @NotNull Disposable var2);

    public abstract void removePropertyChangeListener(@NotNull PropertyChangeListener var1);

    @Nullable
    public abstract Charset getCachedCharsetFromContent(@NotNull Document var1);
}

