/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.List;

public abstract class VcsTaskHandler {
    private static final ExtensionPointName<VcsTaskHandler> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.vcs.taskHandler");

    public static VcsTaskHandler[] getAllHandlers(final Project project) {
        Object[] extensions = (VcsTaskHandler[])EXTENSION_POINT_NAME.getExtensions((AreaInstance)project);
        List handlers = ContainerUtil.filter((Object[])extensions, (Condition)new Condition<VcsTaskHandler>(){

            public boolean value(VcsTaskHandler handler) {
                return handler.isEnabled(project);
            }
        });
        return handlers.toArray(new VcsTaskHandler[handlers.size()]);
    }

    public abstract boolean isEnabled(Project var1);

    public abstract TaskInfo startNewTask(String var1);

    public abstract void switchToTask(TaskInfo var1, Runnable var2);

    public abstract void closeTask(TaskInfo var1, TaskInfo var2);

    public abstract TaskInfo getActiveTask();

    public abstract TaskInfo[] getCurrentTasks();

    public static class TaskInfo {
        public final MultiMap<String, String> branches;

        public TaskInfo(MultiMap<String, String> branches) {
            this.branches = branches;
        }

        public String getName() {
            return this.branches.isEmpty() ? null : (String)this.branches.keySet().iterator().next();
        }

        public boolean equals(Object obj) {
            return this.branches.equals(((TaskInfo)obj).branches);
        }
    }
}

