/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.Details;
import com.intellij.openapi.vcs.ValueConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class GenericDetailsLoader<Id, Data>
implements Details<Id, Data>,
Disposable {
    private final Consumer<Id> myLoader;
    private final ValueConsumer<Id, Data> myValueConsumer;
    private final AtomicReference<Id> myCurrentlySelected;
    private boolean myIsDisposed;

    public GenericDetailsLoader(Consumer<Id> loader, PairConsumer<Id, Data> valueConsumer) {
        this.myLoader = loader;
        this.myValueConsumer = new ValueConsumer<Id, Data>(valueConsumer);
        this.myCurrentlySelected = new AtomicReference<Object>(null);
    }

    public void updateSelection(@Nullable Id id, boolean force) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myIsDisposed) {
            return;
        }
        this.myValueConsumer.setId(id);
        Id wasId = this.myCurrentlySelected.getAndSet(id);
        if (force || !Comparing.equal(id, wasId)) {
            this.myLoader.consume(id);
        }
    }

    public void setCacheConsumer(PairConsumer<Id, Data> cacheConsumer) {
        this.myValueConsumer.setCacheConsumer(cacheConsumer);
    }

    @Override
    public void take(Id id, Data data) throws Details.AlreadyDisposedException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myIsDisposed) {
            throw new Details.AlreadyDisposedException();
        }
        this.myValueConsumer.consume(id, data);
    }

    public void resetValueConsumer() {
        this.myValueConsumer.reset();
    }

    @Override
    public Id getCurrentlySelected() {
        return this.myCurrentlySelected.get();
    }

    public void dispose() {
        this.myIsDisposed = true;
    }
}

