/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class MultiLineLabelUI
extends BasicLabelUI {
    private String myString;
    private String[] myLines;
    static final int LEADING = 10;
    static final int TRAILING = 11;
    static final int LEFT = 2;
    static final int RIGHT = 4;
    static final int TOP = 1;
    static final int CENTER = 0;

    @Override
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        String s = MultiLineLabelUI.layoutCompoundLabel(label, fontMetrics, this.splitStringByLines(text), icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
        if ("".equals(s)) {
            return text;
        }
        return s;
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String[] text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return MultiLineLabelUI.layoutCompoundLabel(fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String[] text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int availTextWidth;
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.length == 0 || text.length == 1 && (text[0] == null || "".equals(text[0]));
        String rettext = "";
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
        } else {
            Dimension dim = MultiLineLabelUI.computeMultiLineDimension(fm, text);
            textR.width = dim.width;
            textR.height = dim.height;
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.width > (availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap)) && text.length == 1) {
            int nChars;
            String clipString = "...";
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            for (nChars = 0; nChars < text[0].length() && (totalWidth += fm.charWidth(text[0].charAt(nChars))) <= availTextWidth; ++nChars) {
            }
            rettext = text[0].substring(0, nChars) + clipString;
            textR.width = SwingUtilities.computeStringWidth(fm, rettext);
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return rettext;
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        g.setColor(l.getForeground());
        this.drawString(g, s, accChar, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        g.setColor(l.getBackground());
        this.drawString(g, s, accChar, textX, textY);
    }

    protected void drawString(Graphics g, String s, int accChar, int textX, int textY) {
        UIUtil.applyRenderingHints((Graphics)g);
        if (s.indexOf(10) == -1) {
            BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
        } else {
            String[] strs = this.splitStringByLines(s);
            int height = g.getFontMetrics().getHeight();
            BasicGraphicsUtils.drawString(g, strs[0], accChar, textX, textY);
            for (int i = 1; i < strs.length; ++i) {
                g.drawString(strs[i], textX, textY + height * i);
            }
        }
    }

    public static Dimension computeMultiLineDimension(FontMetrics fm, String[] strs) {
        int width = 0;
        for (int i = 0; i < strs.length; ++i) {
            width = Math.max(width, SwingUtilities.computeStringWidth(fm, strs[i]));
        }
        return new Dimension(width, fm.getHeight() * strs.length);
    }

    public String[] splitStringByLines(String str) {
        if (str == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (str.equals(this.myString)) {
            return this.myLines;
        }
        this.myString = MultiLineLabelUI.convertTabs(str, 2);
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, "\n\r");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        this.myLines = ArrayUtil.toStringArray(list);
        return this.myLines;
    }

    public static String convertTabs(String text, int tabLength) {
        StringBuffer buf = new StringBuffer(text.length());
        for (int idx = 0; idx < text.length(); ++idx) {
            char ch = text.charAt(idx);
            if (ch == '\t') {
                for (int i = 0; i < tabLength; ++i) {
                    buf.append(' ');
                }
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }
}

